/**
 * Wire up watch button when the content has been rendered.
 */
Zepto(function(){

    var contentRenderedHandler = function(pageView, $container, contentModel) {

        var watch = new ConfluenceMobile.Watch({
            watching: contentModel.get("watching"),
            contentId: contentModel.contentId
        });

        new ConfluenceMobile.WatchView({
            el: $container.find(".content-watch"),
            model: watch
        }).render();
    };

    ConfluenceMobile.contentEventAggregator && ConfluenceMobile.contentEventAggregator.on("render:pre:after-content", contentRenderedHandler);
});