ConfluenceMobile.viewProfileView = Backbone.View.extend({

    el: ".container",

    model: null,

    initialize: function (options) {
        this.$el.empty();
        this.notification = new ConfluenceMobile.Notification(this.el);
        this.notification.showLoading();
        this.model = new ConfluenceMobile.Profile({
           username: options.username
        });

        this.model.bind("change", this.render, this);
        this.model.bind("error", this.errorHandler, this);

        this.model.fetch();
    },

    render: function () {
        this.notification.hide();
        this.$el.html(Confluence.Templates.Mobile.Profile.profile({
            user: this.model.toJSON(),
            emailVisibility: ConfluenceMobile.AppData.get("email-visibility") 
        }));

        ConfluenceMobile.pageEventAggregator.trigger("post-render");

    },

    errorHandler: function (model, resp, options) {
        var username = this.model.get("username");
        var that = this;
        var options = {
            message : AJS.I18n.getText("confluence.mobile.profile.loading.error", username),        
            
            onRetry : function() {
                that.notification.show();
                ConfluenceMobile.router.profile(username);
            },
            
            onCancel : function() {
                window.history.back();
            }
        };
        
        this.notification.hide();
        ConfluenceMobile.genericAjaxErrorHandler(resp, model, options);
    }
});
