/*
 * Interaction to consider
 * user uses @ to trigger autocomplete
 * user uses @ button to trigger autocomplete
 * user dismisses keyboard
 * user dismissed keyboard when scrolled to the bottom of the page
 */

ConfluenceMobile.MentionView = Backbone.View.extend({
    $overlayBlanket: null,
    $userPickerInput: null,
    top: 0,

    className: 'mentions-content',

    events: {
        "click .close-button": "userClose"
    },

    initialize: function (options) {
        this.insertCallback = options.insertCallback || function() {};
        this.cancelCallback = options.cancelCallback || function() {};
        this.blanket = options.blanket;

        this.render();

        this.focusInput();
        this.adjustPosition(); // iOS does not fire focus event when auto focusing, need to fire
        this.$userPickerInput.on("click blur", _.bind(this.adjustPosition, this));
        // close the mentions modal if the user navigates back
        ConfluenceMobile.routerEventAggregator.bind("change", this.close, this);
    },

    render: function() {
        ConfluenceMobile.hideAddressBar();
        this.$el = $(Confluence.Templates.Mobile.Mentions.mentions());
        this.blanket.$el.html(this.$el);
        this.$el.css('top', window.pageYOffset);
        this.$userPickerInput = this.$('.user-picker-input');

        this.autoComplete && this.autoComplete.remove();
        this.autoComplete = new ConfluenceMobile.MentionAutoCompleteView({
            $input: this.$userPickerInput,
            parent: this
        });
        return this;
    },

    focusInput: function(e) {
        this.$userPickerInput.focus();
    },

    // iOS scrolls window when keyboard appears. Reposition the modal.
    adjustPosition: function() {
        setTimeout(_.bind(function() {
            this.$el.css('top', window.pageYOffset);
        }, this), 1);
    },

    userClose: function() {
        this.close();
        this.cancelCallback();
    },

    setUser: function(user) {
        this.insertCallback(user);
        this.close();
    },

    close: function() {
        this.autoComplete && this.autoComplete.remove();
        this.blanket.remove();
        ConfluenceMobile.routerEventAggregator.unbind("change", this.close);
        this.remove();
    }
});

ConfluenceMobile.MentionAutoCompleteView = Backbone.View.extend({
    el: '.results-list-container',
    model: null,
    delay: 300,
    currentQuery: "",

    events: {
        "click .mention-user": "onSelect"
    },

    initialize: function(options) {
        this.parent = options.parent;
        this.$input = options.$input;
        this.$input.keyup(_.bind(this.keyup, this));

        this.model = new ConfluenceMobile.UserList();
        this.model.bind("change", this.render, this);
        this.query = _.debounce(this.query, this.delay); // don't spam REST
    },

    render: function() {
        this.$el.html(Confluence.Templates.Mobile.Mentions.users({
            users: this.model.toJSON()
        }));
        return this;
    },

    keyup: function(e) {
        if (e.which == 13) { // return key submits if only one choice
            var $choices = this.$el.find('a');
            if ($choices.length == 1) {
                $choices.trigger('click');
            }
            return false;
        }
        var userStr = this.$input.val().toLowerCase();
        if (userStr.length > 1 && userStr != this.currentQuery) {
            this.query(userStr);
        }
    },

    query: function(userStr) {
        this.model.fetch({
            success: _.bind(function() {
                this.currentQuery = userStr;
                this.render();
            }, this),
            data: {
                "max-results": 5,
                query: userStr
            }
        })
    },

    onSelect: function(e) {
        e.preventDefault();

        var $selected = $(e.target);
        var user = this.model.get($selected.data("id"));
        this.parent.setUser(user);
    }
});