(function ($) {

    AJS.test.require("com.atlassian.confluence.plugins.confluence-mobile:fly-out-resources");    
    
    module("test convert route to desktop url");

    test("viewing content but content Id missing", function(){
        var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("viewContent", []);
        equal(url, null);
        
        url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("viewContent", null);
        equal(url, null);
    });

    test("viewing content", function () {
        var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("viewContent", ["12345"]);
        ok(url.match(/\?pageId=12345$/));
    });
    
    test("viewing content focused on a comment", function() {
        var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("viewContent", ["12345", "6789"]);
        ok(url.match(/\?pageId=12345\&focusedCommentId=6789#comment-6789$/));
    });
    
    test("viewing a profile", function() {
        var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("profile", ["jimbobwalton"]);
        ok(url.match(/~jimbobwalton$/));
    });
    
    test("viewing dashboard tabs", function(){
        var url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("dashboard", null);
        ok(url.match(/all$/));
        
        url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("dashboard", ["popular"]);
        ok(url.match(/popular$/));
        
        url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("dashboard", ["network"]);
        ok(url.match(/network/));
        
        url = ConfluenceMobile.DesktopSwitch._convertRouteToDesktopUrl("dashboard", ["recentblogs"]);
        ok(url.match(/all$/));        
    });
})(jQuery);