(function ($) {

    AJS.test.require("com.atlassian.confluence.plugins.confluence-mobile:app-frame");    
    
    module("test the ContentLoader and its dependency tracking");

    test("Empty page loader", function() {
        var contentLoader = new ConfluenceMobile.Utils._ContentLoader(null, "a/b/c");
        equal(contentLoader.resourceCount(), 0);
        equal(contentLoader.contextCount(), 0);
    });
    
    test("single resource per element", function() {
        var $elements = $("<LINK data-atlassian-webresource-contents=\"a.b.c:d[1.1]\"><LINK data-atlassian-webresource-contents=\"a.b.c:e[1.1]\"><LINK data-atlassian-webresource-contents=\"x.y.z:z[3]\"><LINK data-atlassian-webresource-contents=\"x.y.z:z[3]\">");
        var contentLoader = new ConfluenceMobile.Utils._ContentLoader($elements, "a/b/c");        
        
        equal(contentLoader.resourceCount(), 3);
        equal(contentLoader.contextCount(), 0);
        
        ok(contentLoader.hasResource("x.y.z:z"));
        ok(contentLoader.hasResource("a.b.c:d"));
        ok(contentLoader.hasResource("a.b.c:e"));
        
        ok(!contentLoader.hasResource("d.e.f:ghi"));
        
        ok(!contentLoader.hasContext("any"));
        
    });
    
    test("multiple resource per element with contexts", function() {
        var $elements = $("<LINK data-atlassian-webresource-contents=\"a.b.c:d[1.1],f.g.h.i:jkl[3.2],a.b.c:e[1.1]\" data-atlassian-webresource-contexts=\"contextA,contextZ\"><LINK data-atlassian-webresource-contents=\"m.n.o.p.q:r[3],a.b.c:e[1.1]\" data-atlassian-webresource-contexts=\"contextA,contextB,contextC\">");
        var contentLoader = new ConfluenceMobile.Utils._ContentLoader($elements, "a/b/c");
        
        equal(contentLoader.resourceCount(), 4);
        equal(contentLoader.contextCount(), 4);
        
        ok(contentLoader.hasResource("a.b.c:d"));
        ok(contentLoader.hasResource("f.g.h.i:jkl"));
        ok(contentLoader.hasResource("a.b.c:e"));
        ok(contentLoader.hasResource("m.n.o.p.q:r"));
        
        ok(contentLoader.hasContext("contextA"));
        ok(contentLoader.hasContext("contextB"));
        ok(contentLoader.hasContext("contextC"));
        ok(contentLoader.hasContext("contextZ"));        
    });
    
    test("add additonal resources and contexts", function() {
        var $elements = $("<LINK data-atlassian-webresource-contents=\"a.b.c:e[1.1]\" data-atlassian-webresource-contexts=\"contextA\">");
        var contentLoader = new ConfluenceMobile.Utils._ContentLoader($elements, "a/b/c");        

        equal(contentLoader.resourceCount(), 1);
        equal(contentLoader.contextCount(), 1);
        
        contentLoader.addResource("x.y.z:zed","2.5");
        contentLoader.addContext("contextZ");
        
        equal(contentLoader.resourceCount(), 2);
        equal(contentLoader.contextCount(), 2);
        
        ok(contentLoader.hasResource("a.b.c:e"));
        ok(contentLoader.hasResource("x.y.z:zed"));        
        
        ok(contentLoader.hasContext("contextA"));
        ok(contentLoader.hasContext("contextZ"));                
    });
})(jQuery);