ConfluenceMobile.PhotoUploader = function(options) {
    var defaults = {
        runtimes: 'html5',
        multipart: false,
        multi_selection: true,
        unique_names: true,
        stop_propagation: true,
        filters: [{title: 'Images', extensions: 'jpeg,jpg,png,gif'}],
        headers: {'X-Atlassian-Token': 'no-check'}
    };
    options = _.extend(defaults, options);
    this.uploader = new plupload.Uploader(options);
};

ConfluenceMobile.PhotoUploader.prototype.init = function() {
    this.uploader.init();

    this.uploader.bind('FilesAdded', function (up, files) {
        new ConfluenceMobile.PhotoUploadDialog({
            blanket: new ConfluenceMobile.BlanketView(),
            uploader: up
        });
        // rename file as iPhone always uploads image.jpg
        for (var fileIndex = 0; fileIndex < files.length; fileIndex++) {
            var extension = files[fileIndex].name.split('.').pop();
            files[fileIndex].name = files[fileIndex].id + "." + extension;
        }
        up.start();
    });

    this.uploader.bind("BeforeUpload", function(up, file){
        var pageId = $("#inner-container").find(".content").data("content-id");
        var url = ConfluenceMobile.AppData.get("confluence-context-path") + "/plugins/drag-and-drop/upload.action";
        var params = {pageId: pageId};

        var extension = file.name.substr(file.name.lastIndexOf(".") + 1);
        params.filename = file.name;
        params.mimeType = plupload.mimeTypes[extension.toLowerCase()] || "application/x-upload-data"; // if we dont have the mime type just send a default
        params.size = file.size;
        up.settings.url = plupload.buildUrl(url, params);
    });

    this.uploader.bind('UploadProgress', function (up, file) {
        ConfluenceMobile.photoUploaderEventAggregator.trigger("update-dialog-progressbar", file);
    });

    this.uploader.bind('StateChanged', function(up){
        if (up.state == plupload.STARTED) {
            ConfluenceMobile.photoUploaderEventAggregator.trigger("show-dialog-progressbar", up.files);
        }
    });

    this.uploader.bind('UploadComplete', function(up, files){
        if (files && files.length > 0) {
            up.splice(0, files.length); // remove uploaded files from queue
            ConfluenceMobile.photoUploaderEventAggregator.trigger("close-photoupload-dialog");
        }
    });

    // When we are able to support multiple file uploads, we probably want to do something useful here
    // eg. change the progress bar to the 2nd, 3rd file etc
    this.uploader.bind('FileUploaded', function(up, file){
        var $commentEditor = $(this.settings.commentContainer).find(".comment-editor");
        ConfluenceMobile.insertInputText($commentEditor, "!" + file.name + "!");
        $commentEditor.focus();
        ConfluenceMobile.Analytics.trackEvent('mobile-photo-upload', 'file-uploaded');
    });
};

ConfluenceMobile.PhotoUploader.prototype.destroy = function() {
    this.uploader.destroy();
};

$(function(){
    ConfluenceMobile.contentEventAggregator && ConfluenceMobile.contentEventAggregator.on("render:pre:after-content", function() {
        $('.plupload.html5').remove(); // garbage collect any existing file uploaders
    });
});
