(function ($) {
    var stringComparator = function(a,b) {
        return a.localeCompare(b);
    };

    AJS.test.require(["com.atlassian.confluence.plugins.confluence-mobile:app-resources"], function () {
        var module = QUnit.module;
        var test = QUnit.test;
        module("test some basic binary search tree functionality", function () {
            test("contains on an empty tree", function(assert) {
                var tree = new ConfluenceMobile.Utils.BinarySearchTree(function(a,b) { /* dummy */ });

                assert.ok(!tree.contains("apples"));
                assert.equal(tree.size(), 0);
            });

            test("contains on a populated tree", function(assert) {
                var tree = new ConfluenceMobile.Utils.BinarySearchTree(stringComparator);
                tree.add("grapefruit");

                assert.ok(tree.contains("grapefruit"));
                assert.ok(!tree.contains("apple"));
                assert.equal(tree.size(), 1);

                tree.add("kiwi");
                assert.ok(tree.contains("kiwi"));
                assert.ok(tree.contains("grapefruit"));
                assert.ok(!tree.contains("apple"));
                assert.equal(tree.size(), 2);

                tree.add("banana");
                assert.ok(tree.contains("banana"));
                assert.ok(tree.contains("kiwi"));
                assert.ok(tree.contains("grapefruit"));
                assert.ok(!tree.contains("apple"));
                assert.equal(tree.size(), 3);

                tree.add("blueberry");
                assert.ok(tree.contains("blueberry"));
                assert.ok(tree.contains("banana"));
                assert.ok(tree.contains("kiwi"));
                assert.ok(tree.contains("grapefruit"));
                assert.ok(!tree.contains("apple"));
                assert.ok(!tree.contains("orange"));
                assert.equal(tree.size(), 4);
            });

            test("test toArray", function(assert) {
                var tree = new ConfluenceMobile.Utils.BinarySearchTree(stringComparator);
                tree.add("tangerine");
                tree.add("banana");
                tree.add("grapefruit");
                tree.add("apple");

                var contents = tree.toArray();
                assert.equal(contents.length, 4);
                assert.equal(contents[0], "apple");
                assert.equal(contents[1], "banana");
                assert.equal(contents[2], "grapefruit");
                assert.equal(contents[3], "tangerine");
            });
        });
    });
})(jQuery);