/**
 * The view for Confluence content.
 */
ConfluenceMobile.ContentView = Backbone.View.extend({

    className: "content",

    initialize: function () {
        this.model.bind("change", this.render, this);
    },

    /**
     * Render the content if it is not empty.
     */
    render: function () {
        var content = this.model.toJSON();
        var currentUser = ConfluenceMobile.AppData.getObject("current-user");

        // jQuery executes `script` blocks it encounters when setting HTML.
        // A lot of these blocks assume a context where `AJS` is available.
        // This will strip out these code blocks.

        var fauxDocFrag = $("<div />");
        fauxDocFrag[0].innerHTML = content.body;

        $(fauxDocFrag).find("script").each(function () {
            $(this).remove();
        });

        content.body = fauxDocFrag.html();

        content.body = soydata.VERY_UNSAFE.ordainSanitizedHtml(content.body);
        this.$el.html(Confluence.Templates.Mobile.Page.displayContent({
            content: content,
            currentUser: currentUser
        }));

        if (content["contentId"]) {
            this.$el.attr("data-content-id", content["contentId"]).addClass("data-content-id-" + content["contentId"]);
        }

        return this;
    }
});
