ConfluenceMobile.User = Backbone.Model.extend({

    getMentionString: function() {
        return this.get('wikiLink');
    },

    getMentionMarkup: function(mentionMarkup) {
        var that = this;
        $.ajax({
            url: ConfluenceMobile.AppData.get("confluence-context-path") + '/rest/tinymce/1/wikixhtmlconverter',
            type: "POST",
            contentType: "application/json; charset=UTF-8",
            data: JSON.stringify({
                wiki: this.get('wikiLink')
            }),
            success: function(data) {
                mentionMarkup.push({
                    mentionString: that.getMentionString(),
                    html: data.replace(/<p>|<\/p>/g, "")
                });
            },
            error: function(xhr, error) {
                console.log("Could not retrieve mention HTML for " + that.get('wikiLink') + ".");
                console.log("readyState: "+xhr.readyState+", status: "+xhr.status+", responseText" + xhr.responseText);
            }
        });
    }
});