/**
 * To avoid pulling all of AUI and its dependencies, this javascript was introduced to bring across only the functionality that need.
 * At the time of writing, we only needed the AJS.format function.
 * -- note on 2019-07-18: Bringing over toInit for easier AMD module writing --
 */

if (typeof AJS == "undefined") {
    var AJS = {};
}

/**
* Replaces tokens in a string with arguments, similar to Java's MessageFormat.
* Tokens are in the form {0}, {1}, {2}, etc.
* @method format
* @param message the message to replace tokens in
* @param arg (optional) replacement value for token {0}, with subsequent arguments being {1}, etc.
* @return {String} the message with the tokens replaced
* @usage AJS.format("This is a {0} test", "simple");
*/
AJS.format = function (message) {
    var token = /^((?:(?:[^']*'){2})*?[^']*?)\{(\d+)\}/, // founds numbers in curly braces that are not surrounded by apostrophes
        apos = /'(?!')/g; // founds "'", bot not "''"
    // we are caching RegExps, so will not spend time on recreating them on each call
    AJS.format = function (message) {
        var args = arguments,
            res = "",
            match = message.match(token);
        while (match) {
             message = message.substring(match[0].length);
             res += match[1].replace(apos, "") + (args.length > ++match[2] ? args[match[2]] : "");
             match = message.match(token);
        }
        return res += message.replace(apos, "");
    };
    return AJS.format.apply(AJS, arguments);
};

 /**
 * Adds functions to the list of methods to be run asynchronously after DomContentLoaded.
 *
 * Wraps error handling around the provided function so its failure won't prevent
 * other init functions running.
 *
 * @param {Function} func Function to be called on initialisation.
 *
 * @return {Object}
 */
 AJS.toInit = function (func) {
    $.when($.ready).then(function () {
        // Ensure that every function passed through toInit happens asynchronously after DomContentLoaded events,
        // and will be executed in its own stack, meaning that the UI can be updated in-between expensive handlers.
        setTimeout(function () {
            try {
                func.call(this, $);
            } catch (ex) {}
        }, 1);
    });

    return this;
};