/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.restapi.v1_0;

import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugins.mobile.dto.CommentDto;
import com.atlassian.confluence.plugins.mobile.dto.ContentDto;
import com.atlassian.confluence.plugins.mobile.dto.FavouriteDto;
import com.atlassian.confluence.plugins.mobile.dto.metadata.ContentMetadataDto;
import com.atlassian.confluence.plugins.mobile.model.Context;
import com.atlassian.confluence.plugins.mobile.model.Inclusions;
import com.atlassian.confluence.plugins.mobile.service.MobileChildContentService;
import com.atlassian.confluence.plugins.mobile.service.MobileContentService;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content")
@Component
public class ContentResource {
    private final MobileContentService mobileContentService;
    private final MobileChildContentService mobileChildContentService;

    @Autowired
    public ContentResource(MobileContentService mobileContentService, MobileChildContentService mobileChildContentService) {
        this.mobileContentService = mobileContentService;
        this.mobileChildContentService = mobileChildContentService;
    }

    @GET
    @Path(value="/{contentId}")
    public ContentDto getContentById(@PathParam(value="contentId") long id) throws ServiceException {
        return this.mobileContentService.getContent(id);
    }

    @GET
    @Path(value="/{contentId}/comment")
    public PageResponse<CommentDto> getCommentsByContainerId(@PathParam(value="contentId") ContentId id, @DefaultValue(value="author,body,parent,container,metadata") @QueryParam(value="expand") String expand, @DefaultValue(value="page") @QueryParam(value="include") String include) throws ServiceException {
        return this.mobileChildContentService.getComments(id, new Expansions(ExpansionsParser.parse((String)expand)), new Inclusions(include));
    }

    @GET
    @Path(value="/{contentId}/metadata")
    public ContentMetadataDto getContentMetadata(@PathParam(value="contentId") ContentId id) {
        return this.mobileContentService.getContentMetadata(id);
    }

    @GET
    @Path(value="/creation/metadata")
    public ContentMetadataDto getCreationContentMetadata(@QueryParam(value="context") @DefaultValue(value="global") String context, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="contentId") Long contentId) {
        return this.mobileContentService.getCreationContentMetadata(new Context(Context.Type.forValue(context), spaceKey, contentId));
    }

    @POST
    @Path(value="/{contentId}/favourite")
    public Boolean favourite(@PathParam(value="contentId") Long id) {
        return this.mobileContentService.favourite(id);
    }

    @DELETE
    @Path(value="/{contentId}/favourite")
    public Boolean removeFavouritePage(@PathParam(value="contentId") Long id) {
        return this.mobileContentService.removeFavourite(id);
    }

    @GET
    @Path(value="/favourites")
    public List<FavouriteDto> getFavourites(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="50") int limit) {
        return this.mobileContentService.getFavourites((PageRequest)new SimplePageRequest(start, limit));
    }

    @GET
    @Path(value="/save")
    public PageResponse<ContentDto> getSavedList(@QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="50") int limit) {
        return this.mobileContentService.getSavedList((PageRequest)new SimplePageRequest(start, limit));
    }

    @GET
    @Path(value="/{contentId}/relation")
    public Map<String, PageResponse> getRelation(@PathParam(value="contentId") long contentId, @QueryParam(value="include") @DefaultValue(value="parent,child,sibling") String include, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="5") int limit) {
        return this.mobileContentService.getRelationContent(contentId, new Expansions(ExpansionsParser.parse((String)expand)), new Inclusions(include), (PageRequest)new SimplePageRequest(start, limit));
    }
}

