package com.atlassian.confluence.plugins.mentions.notifications;

import com.atlassian.confluence.notifications.NotificationPayload;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;

public interface MentionContentPayload extends NotificationPayload {
    long getContentId();

    ContentTypeEnum getContentType();

    UserKey getMentionedUserKey();

    Option<String> getMentionHtml();

    Maybe<UserKey> getAuthorUserKey();
}

