package com.atlassian.confluence.plugins.mentions.conditions;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugin.descriptor.mail.conditions.AbstractNotificationCondition;

/**
 * Checks whether we should display the view page button action in a mention email
 */
public class ShowViewPageLinkCondition extends AbstractNotificationCondition {

    @Override
    protected boolean shouldDisplay(NotificationContext context) {
        final ConfluenceEntityObject content = context.getContent();
        return content instanceof AbstractPage
                && Page.CONTENT_TYPE.equals(((AbstractPage) content).getType());
    }
}
