package com.atlassian.confluence.plugins.mentions.api;

import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.ContentEntityObject;

import java.util.Set;

/**
 * Component providing methods to find mentions in content.
 * <p>
 * The returned set of usernames contains all users mentioned in the content and does not do any permission checking.
 * Permission checking is left as an excercise for the caller.
 */
public interface MentionFinder {
    /**
     * Gets all mentioned usernames in the content entity object. Mentions are looked for in the body.
     *
     * @param ceo the content entity object
     * @return a set of usernames, never null
     */
    Set<String> getMentionedUsernames(ContentEntityObject ceo);

    /**
     * Gets all mentioned usernames in the body content.
     *
     * @param content the body content
     * @return a set of usernames, never null
     */
    Set<String> getMentionedUsernames(BodyContent content);

    /**
     * Gets all new mentioned usernames in the new body content with respect to the old body content. Useful when
     * you want to find new mentions in an edited page / blog post.
     *
     * @param oldContent the old version of the body content
     * @param newContent the new version of the body content
     * @return a set of the new usernames mentioned, never null
     */
    Set<String> getNewMentionedUsernames(BodyContent oldContent, BodyContent newContent);
}
