package com.atlassian.confluence.plugins.mentions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.ConfluenceUser;

import java.util.Set;

public interface NotificationService {
    /**
     * send mention notifications to target users, permission filters are applied
     *
     * @param mentionedUsers target users
     * @param author         mention author
     * @param content        content with mentions added
     * @since 2.0.0
     */
    void sendMentions(final Set<ConfluenceUser> mentionedUsers,
                      final ConfluenceUser author,
                      final ContentEntityObject content);
}