/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mentions.rest;

import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.plugins.rest.entities.ContentEntity;
import com.atlassian.confluence.plugins.rest.entities.SearchResultEntityList;
import com.atlassian.confluence.plugins.rest.entities.builders.PersonalInformationContentEntityBuilder;
import com.atlassian.confluence.plugins.rest.manager.DateEntityFactory;
import com.atlassian.confluence.plugins.rest.manager.UserEntityHelper;
import com.atlassian.confluence.plugins.rest.resources.AbstractResource;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/network")
public class NetworkResource
extends AbstractResource {
    private final FollowManager followManager;
    private final PermissionManager permissionManager;
    private final PersonalInformationManager personalInformationManager;
    private final UserAccessor userAccessor;
    private final SettingsManager settingsManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final DateEntityFactory dateEntityFactory;

    public NetworkResource(FollowManager followManager, PermissionManager permissionManager, UserAccessor userAccessor, PersonalInformationManager personalInformationManager, SettingsManager settingsManager, I18NBeanFactory i18NBeanFactory, SpacePermissionManager spacePermissionManager, WebResourceUrlProvider webResourceUrlProvider, DateEntityFactory dateEntityFactory) {
        super(userAccessor, spacePermissionManager);
        this.followManager = followManager;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
        this.personalInformationManager = personalInformationManager;
        this.settingsManager = settingsManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.dateEntityFactory = dateEntityFactory;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doSearch(@QueryParam(value="max-results") Integer maxResults) {
        this.createRequestContext();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null || !this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, PermissionManager.TARGET_PEOPLE_DIRECTORY)) {
            return Response.noContent().build();
        }
        if (maxResults == null) {
            maxResults = 10;
        }
        ImmutableSet users = new LinkedHashSet();
        users.add(currentUser);
        users.addAll(this.followManager.getFollowing(currentUser));
        if (users.size() < maxResults) {
            Iterator followers = this.followManager.getFollowers((User)currentUser).iterator();
            while (users.size() < maxResults && followers.hasNext()) {
                users.add(this.userAccessor.getUserByName((String)followers.next()));
            }
        }
        if (users.size() > maxResults) {
            users = ImmutableSet.copyOf((Iterable)Iterables.limit(users, (int)maxResults));
        }
        ArrayList<ContentEntity> resultList = new ArrayList<ContentEntity>(users.size());
        PersonalInformationContentEntityBuilder entityBuilder = new PersonalInformationContentEntityBuilder(this.settingsManager, this.dateEntityFactory, this.userAccessor, new UserEntityHelper(this.userAccessor, this.settingsManager, this.webResourceUrlProvider, this.i18NBeanFactory));
        for (ConfluenceUser networkUser : users) {
            PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)networkUser);
            ContentEntity contentEntity = entityBuilder.build(personalInformation);
            resultList.add(contentEntity);
        }
        SearchResultEntityList searchResultEntityList = new SearchResultEntityList();
        searchResultEntityList.setResults(resultList);
        searchResultEntityList.setTotalSize(resultList.size());
        return Response.ok((Object)searchResultEntityList).build();
    }
}

