/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mentions;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.mentions.MentionsExcerptor;
import com.atlassian.confluence.plugins.mentions.NotificationService;
import com.atlassian.confluence.plugins.mentions.api.ConfluenceMentionEvent;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class NotificationServiceImpl
implements NotificationService {
    private static final MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
    private final EventPublisher eventPublisher;
    private final UserManager userManager;
    private final UserAccessor userAccessor;
    private final Renderer renderer;
    private final MentionsExcerptor mentionsExcerptor;

    public NotificationServiceImpl(EventPublisher eventPublisher, UserManager userManager, UserAccessor userAccessor, Renderer renderer, MentionsExcerptor mentionsExcerptor) {
        this.userManager = userManager;
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.renderer = renderer;
        this.mentionsExcerptor = mentionsExcerptor;
    }

    @Override
    @Deprecated
    public void sendMentionsEmail(Iterable<String> userNames, ContentEntityObject content) {
        HashSet<ConfluenceUser> mentionedUsers = new HashSet<ConfluenceUser>();
        for (String username : userNames) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            if (user == null) continue;
            mentionedUsers.add(user);
        }
        ConfluenceUser author = AuthenticatedUserThreadLocal.get();
        this.sendMentions(mentionedUsers, author, content);
    }

    @Override
    @Deprecated
    public void sendMentionEmails(Set<ConfluenceUser> mentionedUsers, ConfluenceUser author, ContentEntityObject content) {
        this.sendMentions(mentionedUsers, author, content);
    }

    @Override
    public void sendMentions(Set<ConfluenceUser> mentionedUsers, ConfluenceUser author, ContentEntityObject content) {
        if (mentionedUsers.isEmpty()) {
            return;
        }
        PageContext renderContext = content.toPageContext();
        renderContext.setOutputType("email");
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)renderContext);
        ContentTypeEnum contentType = content.getTypeEnum();
        switch (contentType) {
            case COMMENT: {
                String commentMention = content.getBodyContent().getBodyType() == BodyType.XHTML ? this.renderer.render(content, (ConversionContext)conversionContext) : null;
                for (ConfluenceUser recipient : mentionedUsers) {
                    this.sendUserMention(recipient, author, content, commentMention);
                }
                break;
            }
            case PAGE: 
            case BLOG: 
            case CUSTOM: {
                for (ConfluenceUser recipient : mentionedUsers) {
                    String excerpt = this.mentionsExcerptor.getExcerpt(content, recipient);
                    String mentionHtml = StringUtils.isNotBlank((CharSequence)excerpt) ? this.renderer.render(excerpt, (ConversionContext)conversionContext) : null;
                    this.sendUserMention(recipient, author, content, mentionHtml);
                }
                break;
            }
        }
    }

    private void sendUserMention(ConfluenceUser recipient, ConfluenceUser author, ContentEntityObject content, String mentionHtml) {
        UserProfile recipientProfile = this.userManager.getUserProfile(recipient.getKey());
        ConfluenceMentionEvent event = new ConfluenceMentionEvent(this, content, recipientProfile, author, mentionHtml);
        this.eventPublisher.publish((Object)event);
    }

    static {
        try {
            fileTypeMap.addMimeTypes(IOUtils.toString((InputStream)BootstrapManager.class.getResourceAsStream("/mime.types")));
        }
        catch (IOException exception) {
            throw new RuntimeException("Unable to load mime types", exception);
        }
    }
}

