package com.atlassian.confluence.plugins.mentions.notifications;

import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Optional;

public class SimpleMentionContentPayload implements MentionContentPayload {

    @JsonProperty
    private long contentId;
    @JsonProperty
    private ContentTypeEnum contentType;
    @JsonProperty
    private String mentionedUserKey;
    @JsonProperty
    private String mentionedHtml;
    @JsonProperty
    private String originatingUserKey;
    @JsonProperty
    private UserKey authorUserKey;

    // required for json serialisation
    @SuppressWarnings("unused")
    public SimpleMentionContentPayload() {
    }

    /**
     * @deprecated since 2.0.0
     */
    @Deprecated
    public SimpleMentionContentPayload(
            final long contentId,
            final ContentTypeEnum contentType,
            final UserKey originatingUserKey,
            final String mentionedUserKey,
            final String mentionedHtml) {
        this.contentId = contentId;
        this.contentType = contentType;
        this.mentionedUserKey = mentionedUserKey;
        this.mentionedHtml = mentionedHtml;
        this.originatingUserKey = originatingUserKey.getStringValue();
    }

    public SimpleMentionContentPayload(
            final long contentId,
            final ContentTypeEnum contentType,
            final UserKey originatingUserKey,
            final UserKey mentionedUserKey,
            final String mentionedHtml) {
        this.contentId = contentId;
        this.contentType = contentType;
        this.mentionedUserKey = mentionedUserKey != null ? mentionedUserKey.getStringValue() : null;
        this.mentionedHtml = mentionedHtml;
        this.originatingUserKey = originatingUserKey != null ? originatingUserKey.getStringValue() : null;
        this.authorUserKey = originatingUserKey;
    }


    @Override
    public long getContentId() {
        return contentId;
    }

    @Override
    public ContentTypeEnum getContentType() {
        return contentType;
    }

    @Override
    public UserKey getMentionedUserKey() {
        return new UserKey(mentionedUserKey);
    }

    @Override
    public Option<String> getMentionHtml() {
        if (StringUtils.isBlank(mentionedHtml)) {
            return Option.none();
        } else {
            return Option.some(mentionedHtml);
        }
    }

    @Override
    public Maybe<UserKey> getAuthorUserKey() {
        return Option.option(authorUserKey);
    }

    @Override
    public Maybe<String> getOriginatingUserKey() {
        return Option.option(originatingUserKey);
    }

    @Override
    public Optional<UserKey> getOriginatorUserKey() {
        return StringUtils.isEmpty(originatingUserKey) ? Optional.empty() : Optional.of(new UserKey(originatingUserKey));
    }
}
