package com.atlassian.confluence.plugins.mentions;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.mentions.api.ConfluenceMentionEvent;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import javax.activation.MimetypesFileTypeMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import static com.atlassian.confluence.core.BodyType.XHTML;

public class NotificationServiceImpl implements NotificationService {
    private static final MimetypesFileTypeMap fileTypeMap;

    static {
        fileTypeMap = new MimetypesFileTypeMap();
        try {
            fileTypeMap.addMimeTypes(IOUtils.toString(BootstrapManager.class.getResourceAsStream("/mime.types")));
        } catch (IOException exception) {
            throw new RuntimeException("Unable to load mime types", exception);
        }
    }

    private final EventPublisher eventPublisher;
    private final UserManager userManager;
    private final UserAccessor userAccessor;
    private final Renderer renderer;
    private final MentionsExcerptor mentionsExcerptor;

    public NotificationServiceImpl(final EventPublisher eventPublisher,
                                   final UserManager userManager,
                                   final UserAccessor userAccessor,
                                   final Renderer renderer,
                                   final MentionsExcerptor mentionsExcerptor) {
        this.userManager = userManager;
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.renderer = renderer;
        this.mentionsExcerptor = mentionsExcerptor;
    }

    /**
     * @deprecated since 2.0.0
     */
    @Deprecated
    @Override
    public void sendMentionsEmail(final Iterable<String> userNames, final ContentEntityObject content) {
        Set<ConfluenceUser> mentionedUsers = new HashSet<>();
        for (String username : userNames) {
            ConfluenceUser user = userAccessor.getUserByName(username);
            if (user != null)
                mentionedUsers.add(user);
        }
        ConfluenceUser author = AuthenticatedUserThreadLocal.get();
        sendMentions(mentionedUsers, author, content);
    }

    /**
     * @deprecated since 2.0.0
     */
    @Deprecated
    @Override
    public void sendMentionEmails(final Set<ConfluenceUser> mentionedUsers,
                                  final ConfluenceUser author,
                                  final ContentEntityObject content) {
        sendMentions(mentionedUsers, author, content);
    }

    @Override
    public void sendMentions(final Set<ConfluenceUser> mentionedUsers,
                             final ConfluenceUser author,
                             final ContentEntityObject content) {
        if (mentionedUsers.isEmpty()) {
            return;
        }

        final RenderContext renderContext = content.toPageContext();
        renderContext.setOutputType(RenderContext.EMAIL);

        final ConversionContext conversionContext = new DefaultConversionContext(renderContext);
        final ContentTypeEnum contentType = content.getTypeEnum();

        switch (contentType) {
            case COMMENT:
                final String commentMention = content.getBodyContent().getBodyType() == XHTML
                        ? renderer.render(content, conversionContext)
                        : null;
                for (final ConfluenceUser recipient : mentionedUsers) {
                    sendUserMention(recipient, author, content, commentMention);
                }
                break;
            case PAGE:
            case BLOG:
            case CUSTOM:
                for (final ConfluenceUser recipient : mentionedUsers) {
                    final String excerpt = mentionsExcerptor.getExcerpt(content, recipient);
                    final String mentionHtml = StringUtils.isNotBlank(excerpt)
                            ? renderer.render(excerpt, conversionContext)
                            : null;
                    sendUserMention(recipient, author, content, mentionHtml);
                }
                break;
            default:
                break;
        }
    }

    private void sendUserMention(final ConfluenceUser recipient,
                                 final ConfluenceUser author,
                                 final ContentEntityObject content,
                                 final String mentionHtml) {
        final UserProfile recipientProfile = userManager.getUserProfile(recipient.getKey());
        final ConfluenceMentionEvent event = new ConfluenceMentionEvent(
                this,
                content,
                recipientProfile,
                author,
                mentionHtml
        );
        eventPublisher.publish(event);
    }
}
