/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail;

import com.atlassian.confluence.event.events.content.Contented;
import com.atlassian.confluence.event.events.types.ConfluenceEntityUpdated;
import com.atlassian.confluence.event.events.types.Removed;
import com.atlassian.confluence.event.events.types.Trashed;
import com.atlassian.confluence.event.events.types.Updated;
import com.atlassian.confluence.plugins.pageproperties.api.model.PageProperty;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class CachingDetailsManager
implements InitializingBean,
DisposableBean {
    private static final String CACHE_NAME = CachingDetailsManager.class.getName();
    private final com.atlassian.util.concurrent.Supplier<StableReadExternalCache<ImmutableMap<String, ImmutableList<ImmutableMap<String, PageProperty>>>>> cacheRef;
    private final EventListenerRegistrar eventListenerRegistrar;

    public CachingDetailsManager(VCacheFactory cacheFactory, EventListenerRegistrar eventListenerRegistrar) {
        this.eventListenerRegistrar = eventListenerRegistrar;
        this.cacheRef = Lazy.supplier(() -> this.createCache(cacheFactory));
    }

    private StableReadExternalCache<ImmutableMap<String, ImmutableList<ImmutableMap<String, PageProperty>>>> createCache(VCacheFactory cacheFactory) {
        return cacheFactory.getStableReadExternalCache(CACHE_NAME, MarshallerFactory.serializableMarshaller(ImmutableMap.class), new ExternalCacheSettingsBuilder().build());
    }

    public ImmutableMap<String, ImmutableList<ImmutableMap<String, PageProperty>>> get(long pageId, Supplier<ImmutableMap<String, ImmutableList<ImmutableMap<String, PageProperty>>>> loader) {
        return (ImmutableMap)VCacheUtils.join((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).get(Long.toString(pageId), loader));
    }

    @EventListener
    public void onContentUpdated(Updated event) {
        this.invalidateCacheOnContentEvent(event);
    }

    @EventListener
    public void onContentRemoved(Removed event) {
        this.invalidateCacheOnContentEvent(event);
    }

    @EventListener
    public void onContentTrashed(Trashed event) {
        this.invalidateCacheOnContentEvent(event);
    }

    @EventListener
    public void onConfluenceEntityUpdated(ConfluenceEntityUpdated event) {
        this.invalidateCacheOnContentEvent(event);
    }

    @EventListener
    public void onPluginEnable(PluginEnabledEvent event) {
        if (event.getPlugin().getKey().equals("confluence.extra.masterdetail")) {
            this.clearCache();
        }
    }

    private void invalidateCacheOnContentEvent(Object event) {
        if (event instanceof Contented) {
            VCacheUtils.join((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).remove(new String[]{((Contented)event).getContent().getIdAsString()}));
        }
    }

    public void clearCache() {
        VCacheUtils.join((CompletionStage)((StableReadExternalCache)this.cacheRef.get()).removeAll());
    }

    public void destroy() throws Exception {
        this.eventListenerRegistrar.unregister((Object)this);
        this.clearCache();
    }

    public void afterPropertiesSet() throws Exception {
        this.eventListenerRegistrar.register((Object)this);
        this.clearCache();
    }
}

