/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail;

import com.atlassian.confluence.extra.masterdetail.ExtractedDetails;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtractedDetailsComparator
implements Comparator<ExtractedDetails> {
    private final String key;
    private final boolean reverseSort;
    private static final String DATE_PATTERN = "(.*)\"(\\d\\d\\d\\d-\\d\\d-\\d\\d)\"(.*)";
    private static Pattern regex = Pattern.compile("(.*)\"(\\d\\d\\d\\d-\\d\\d-\\d\\d)\"(.*)", 32);
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");

    public ExtractedDetailsComparator(String key, boolean reverseSort) {
        this.key = key;
        this.reverseSort = reverseSort;
    }

    @Override
    public int compare(ExtractedDetails first, ExtractedDetails second) {
        boolean titleKey = "title".equalsIgnoreCase(this.key);
        String firstValue = this.getValue(first, titleKey);
        String secondValue = this.getValue(second, titleKey);
        try {
            Date firstDate = ExtractedDetailsComparator.extractDate(firstValue);
            Date secondDate = ExtractedDetailsComparator.extractDate(secondValue);
            return !this.reverseSort ? firstDate.compareTo(secondDate) : secondDate.compareTo(firstDate);
        }
        catch (ParseException firstDate) {
            int comparison = firstValue.compareToIgnoreCase(secondValue);
            return this.reverseSort ? -comparison : comparison;
        }
    }

    private static Date extractDate(String value) throws ParseException {
        Matcher regexMatcher = regex.matcher(value);
        if (regexMatcher.find()) {
            return DATE_FORMATTER.parse(regexMatcher.group(2));
        }
        throw new ParseException("Can't extract date", 0);
    }

    private String getValue(ExtractedDetails first, boolean titleKey) {
        String firstValue;
        if (first == null) {
            return "";
        }
        String string = firstValue = titleKey ? first.getTitle() : first.getDetailStorageFormat(this.key);
        if (firstValue == null) {
            return "";
        }
        return firstValue;
    }
}

