/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.metadata.jira.aggregate;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.ConfigurableCache;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraAggregate;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraAggregateCacheStore {
    static final String CACHE_NAME = JiraAggregateCacheStore.class.getCanonicalName();
    static final String ERROR_CACHE_NAME = CACHE_NAME + "Errors";
    private final ConfigurableCache cache;
    private final ConfigurableCache errorCache;
    private long currentTTLInMillis;

    @Autowired
    public JiraAggregateCacheStore(CacheManager cacheManager) {
        Cache cache = cacheManager.getCache(CACHE_NAME);
        Cache errorCache = cacheManager.getCache(ERROR_CACHE_NAME);
        if (!(cache instanceof ConfigurableCache) || !(errorCache instanceof ConfigurableCache)) {
            throw new RuntimeException("Expected cache to implement " + ConfigurableCache.class + " so that time to live of cache items can be adjusted.");
        }
        this.cache = (ConfigurableCache)cache;
        this.cache.setTimeToLive(5L, TimeUnit.MINUTES);
        this.currentTTLInMillis = TimeUnit.MINUTES.toMillis(5L);
        this.errorCache = (ConfigurableCache)errorCache;
        this.errorCache.setTimeToLive(5L, TimeUnit.MINUTES);
    }

    JiraAggregate get(long pageId) {
        JiraAggregate aggregateData = (JiraAggregate)this.cache.get((Object)pageId);
        if (aggregateData == null) {
            aggregateData = (JiraAggregate)this.errorCache.get((Object)pageId);
        }
        return aggregateData;
    }

    void put(long pageId, JiraAggregate aggregateData) {
        if (aggregateData.isIncomplete()) {
            this.errorCache.put((Object)pageId, (Object)aggregateData);
        } else {
            this.cache.put((Object)pageId, (Object)aggregateData);
        }
    }

    void invalidate(long pageId) {
        this.cache.remove((Object)pageId);
        this.errorCache.remove((Object)pageId);
    }

    void invalidateAll() {
        this.cache.removeAll();
        this.errorCache.removeAll();
    }

    void setTimeToLive(long time, TimeUnit unit) {
        long timeInMillis = unit.toMillis(time);
        if (timeInMillis != this.currentTTLInMillis) {
            if (timeInMillis > this.currentTTLInMillis) {
                this.cache.removeAll();
            }
            this.cache.setTimeToLive(time, unit);
            this.currentTTLInMillis = timeInMillis;
        }
    }
}

