/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.metadata.jira.aggregate;

import com.atlassian.confluence.plugins.metadata.jira.aggregate.JiraAggregateCacheStore;
import com.atlassian.confluence.plugins.metadata.jira.aggregate.JiraAggregateExecutorService;
import com.atlassian.confluence.plugins.metadata.jira.aggregate.JiraAggregateProvider;
import com.atlassian.confluence.plugins.metadata.jira.helper.JiraMetadataErrorHelper;
import com.atlassian.confluence.plugins.metadata.jira.model.JiraAggregate;
import com.google.common.collect.Maps;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraAggregateCacheLoader {
    private final ConcurrentMap<Long, Future<JiraAggregate>> loading;
    private final ExecutorService executorService;
    private final JiraAggregateProvider jiraAggregateProvider;
    private final JiraAggregateCacheStore jiraAggregateCacheStore;

    @Autowired
    public JiraAggregateCacheLoader(JiraAggregateProvider jiraAggregateProvider, JiraAggregateCacheStore jiraAggregateCacheStore, JiraAggregateExecutorService jiraAggregateExecutorService) {
        this.jiraAggregateProvider = jiraAggregateProvider;
        this.jiraAggregateCacheStore = jiraAggregateCacheStore;
        this.executorService = jiraAggregateExecutorService.getExecutorService();
        this.loading = Maps.newConcurrentMap();
    }

    Future<JiraAggregate> loadCacheAsync(long pageId, JiraMetadataErrorHelper errorHelper) {
        FutureCallable<JiraAggregate> newTask = this.createCacheLoadingTask(pageId, errorHelper);
        Future<JiraAggregate> currentTask = (Future<JiraAggregate>)this.loading.putIfAbsent(pageId, newTask);
        if (currentTask == null) {
            try {
                currentTask = this.executorService.submit(newTask);
                this.loading.put(pageId, currentTask);
            }
            catch (Exception e) {
                this.loading.remove(pageId);
                errorHelper.handleException(e);
            }
        }
        return currentTask;
    }

    private FutureCallable<JiraAggregate> createCacheLoadingTask(final long pageId, final JiraMetadataErrorHelper errorHelper) {
        return new FutureCallable<JiraAggregate>(new Callable<JiraAggregate>(){

            @Override
            public JiraAggregate call() throws Exception {
                try {
                    JiraAggregate aggregateData = JiraAggregateCacheLoader.this.jiraAggregateCacheStore.get(pageId);
                    if (aggregateData == null) {
                        aggregateData = JiraAggregateCacheLoader.this.jiraAggregateProvider.getAggregateData(pageId, errorHelper);
                        if (!Thread.currentThread().isInterrupted()) {
                            JiraAggregateCacheLoader.this.jiraAggregateCacheStore.put(pageId, aggregateData);
                        }
                    }
                    JiraAggregate jiraAggregate = aggregateData;
                    return jiraAggregate;
                }
                catch (Exception e) {
                    errorHelper.handleException(e);
                    JiraAggregate jiraAggregate = null;
                    return jiraAggregate;
                }
                finally {
                    JiraAggregateCacheLoader.this.loading.remove(pageId);
                }
            }
        });
    }

    void invalidateCacheLoadingTask(long pageId) {
        Future task = (Future)this.loading.get(pageId);
        if (task != null) {
            task.cancel(true);
        }
    }

    void invalidateAllCacheLoadingTasks() {
        for (Future task : this.loading.values()) {
            task.cancel(true);
        }
    }

    JiraAggregate getValue(long pageId, JiraMetadataErrorHelper errorHelper) {
        JiraAggregate aggregateData = this.getAggregateFromTask((Future)this.loading.get(pageId), errorHelper);
        if (aggregateData == null) {
            aggregateData = this.getAggregateFromTask(this.loadCacheAsync(pageId, errorHelper), errorHelper);
        }
        return aggregateData;
    }

    private JiraAggregate getAggregateFromTask(Future<JiraAggregate> task, JiraMetadataErrorHelper errorHelper) {
        if (task != null) {
            try {
                return task.get();
            }
            catch (Exception e) {
                errorHelper.handleException(e);
            }
        }
        return null;
    }

    private class FutureCallable<V>
    extends FutureTask<V>
    implements Callable<V> {
        private Callable<V> callable;

        public FutureCallable(Callable callable) {
            super(callable);
            this.callable = callable;
        }

        @Override
        public V call() throws Exception {
            return this.callable.call();
        }
    }
}

