define('confluence/cjc/issue/model', [
    'ajs',
    'underscore',
    'backbone',
    'confluence/cjc/error/error-type',
    'confluence/cjc/issue-field/collection'
],
function(
    AJS,
    _,
    Backbone,
    ErrorType,
    IssueFieldCollection
) {
    'use strict';

    var IssueModel = Backbone.Model.extend({

        defaults: {
            // column index in table content if have
            indexColumn: -1,
            // row index in table content if have
            indexRow: -1,
            // supported field collection, ex: summary, description, duedate...
            fields: null
        },

        initialize: function() {
            this.set('fields', new IssueFieldCollection());
        },

        validate: function() {
            var errors = [];

            this.get('fields').each(function(issueField) {
                var error = issueField.validate();
                if (error) {
                    errors.push(error);
                }
            });

            // remove undefined value
            errors = _.filter(errors, function(error) {
                return !!error;
            });

            return errors;
        }
    });

    return IssueModel;
});



