define('confluence/cjc/issue-field/collection', [
    'underscore',
    'backbone',
    'confluence/cjc/issue-field/model'
],
function(
    _,
    Backbone,
    IssueFieldModel
) {
    'use strict';

    var IssueFieldCollection = Backbone.Collection.extend({
        model: IssueFieldModel,

        setFieldRequired: function(fieldName, isRequired) {
            var foundModel = this.findWhere({name: fieldName});

            if (foundModel) {
                foundModel.set('required', isRequired);
            }
        },

        getAllFieldNames: function() {
            return this.map(function(model) {
                return model.get('name');
            });
        },

        getIssueFieldByName: function(fieldName) {
            return this.findWhere({name: fieldName});
        }
    });

    return IssueFieldCollection;

});


