define('confluence/cjc/error/error-type', [
    'jquery',
    'underscore',
    'ajs',
    'backbone'
],
function(
    $,
    _,
    AJS,
    Backbone
) {
    'use strict';

    var ErrorType = Backbone.Model.extend({

        defaults: {
            type: '',
            isWarning: false,
            isCritical: false,

            // some error type has default error message which is defined in `initialize` function,
            // so when we add error message to UI, we don't need specific error message content.
            errorMessageContent: '',

            // always keep error message - don't remove it from collection
            // when reset error message view if it has `isPersistent=true`
            isPersistent: false
        },

        initialize: function() {
            if (this.get('type') === ErrorType.WARNING_SORTED_TABLE_ID) {
                this.set('isWarning', true);
                this.set('isPersistent', true);

                var msg = AJS.I18n.getText('createjiracontent.messages.issues.not.added.reason.sortedtable');
                this.set('errorMessageContent', msg);
            }

            if (this.get('type') === ErrorType.ERROR_FORM_ID) {
                this.set('isCritical', true);
            }

            if (this.get('type') === ErrorType.ERROR_CAN_NOT_DETECT_TABLE_HEADER) {
                this.set('errorMessageContent', AJS.I18n.getText('createjiracontent.dialog.create.issue.error.can.not.find.table.header'));
            }
        }

    }, {
        WARNING_SORTED_TABLE_ID: 'warning-message-sorted-table',
        ERROR_INVALID_SUBMIT_DATA_ID: 'error-message-invalid-submit-data',
        ERROR_JIRA_SERVER_ID: 'error-message-jiraserver-issue',
        ERROR_FORM_ID: 'error-message-create-issue-form',
        ERROR_CAN_NOT_DETECT_TABLE_HEADER: 'error-can-not-detect-table-header'
    });

    return ErrorType;
});