define('confluence/cjc/jira-inline-dialog', [
    'jquery',
    'ajs',
    'confluence/cjc/analytics',
    'confluence/cjc/create-issue-form/create-issue-form-dialog-view'
], function(
    $,
    AJS,
    analytics,
    CreateIssueFormView
) {
    'use strict';

    $.extend(Confluence.CreateJiraContent.Dialogs, (function($) {
        var DIALOG_WIDTH = 360;
        // What is the max height the dialog can have (error message, create from table link, etc)
        // Need to know max height to determine if there is enough space to display the dialog above highlighted text
        var DIALOG_MAX_HEIGHT = 500;
        var FEATURE_DISCOVERY_DIALOG_WIDTH = 370;
        var createIssueDialog;
        var featureDiscoveryDialog;

        var defaultDialogOptions = {
            hideDelay: null,
            maxHeight: DIALOG_MAX_HEIGHT
        };

        function showCreateIssueDialog(selectionObject) {
            // instance of CreateIssueFormView
            var createIssueFormView = new CreateIssueFormView();
            createIssueDialog && createIssueDialog.remove();

            var options = {
                preHideCallback: function() {
                    // don't hide the dialog if issue creation process is under way
                    // or if a select2 menu is open (because it will steal focus)
                    // We also need to prevent hiding when we click on a datepicker which is also use inline-dialog,
                    // the idea is check if the datefield has focus or not.
                    var focusedField = $(document.activeElement); // we don't use .is(':focus') because it will fail by web-kit bug.
                    var isSelect2Field = focusedField.is('#jira-content-create-issue-form [data-aui-dp-uuid]') || // is date field or
                        focusedField.is('#jira-content-create-issue-form input.select2-input.select2-focused') || // label field or
                        focusedField.is('#jira-content-create-issue-form .select2-focusser.select2-offscreen'); // select box field

                    return ($('#formSpinner.aui-icon.aui-icon-wait').length === 0) &&
                            (!$('#select2-drop-mask').is(':visible')) &&
                            !isSelect2Field && // select2 field has focused
                            !$('.aui-inline-dialog .ui-datepicker-inline').is(':visible'); // This line prevent Jira Content Dialog hide when click on an entry from DatePicker
                },
                width : DIALOG_WIDTH,
                hideCallback: function() {
                    if (createIssueFormView) {
                        createIssueFormView.bindHideEventToDialog();
                    }
                }
            };

            var displayFn = function(content, trigger, showPopup) {
                createIssueFormView.render(content, selectionObject);
                window.Confluence.CreateJiraContent.createIssueFormView = createIssueFormView;
                showPopup();
                return false;
            };

            createIssueDialog = _openDialog(selectionObject, 'create-issue-dialog', options, displayFn);
            createIssueFormView.setDialogObject(createIssueDialog);
            analytics.sendAnalyticsForDialogOpen();
        }

        function showFeatureDiscoveryDialog(selectionObject) {
            featureDiscoveryDialog && featureDiscoveryDialog.remove();

            var options = {
                width : FEATURE_DISCOVERY_DIALOG_WIDTH
            };

            var displayFn = function(content, trigger, showPopup) {
                Confluence.CreateJiraContent.FeatureDiscovery.addFeatureDiscoveryContent(content, selectionObject, showCreateIssueDialog);
                showPopup();
                return false;
            };

            featureDiscoveryDialog = _openDialog(selectionObject, 'create-issue-feature-discovery-dialog', options, displayFn);
            Confluence.CreateJiraContent.FeatureDiscovery.setFeatureDialogObject(featureDiscoveryDialog);
        }

        function _openDialog(selectionObject, id, options, displayFn) {
            var $target = $("<div>");
            Confluence.CreateJiraContent.Dialogs.appendDialogTarget(selectionObject.area.average, $target);

            var originalCallback = options.hideCallback;
            options.hideCallback = function() {
                $target.remove(); // clean up dialog target element when hiding the dialog
                originalCallback && originalCallback();
            };

            var dialog = Confluence.ScrollingInlineDialog($target, id, displayFn, $.extend({}, defaultDialogOptions, options));
            dialog.show();
            return dialog;
        }

        return {
            showCreateIssueDialog: showCreateIssueDialog,
            showFeatureDiscoveryDialog: showFeatureDiscoveryDialog
        };
    })($));

});

require('confluence/cjc/module-exporter').safeRequire('confluence/cjc/jira-inline-dialog');