AJS.toInit(function($) {
    var PLUGIN_KEY = "com.atlassian.confluence.plugins.confluence-jira-content:create-Jira-issue-summary";
    var WEB_RESOURCE_KEY = "wr!com.atlassian.confluence.plugins.confluence-jira-content:confluence-jira-content-resources";
    var LOADING_TEXT = AJS.I18n.getText("createjiracontent.dialog.loading.text");
    var loaded = false;

    var $msgPanel = $("div.jira-issues-created");
    if ($msgPanel.length > 0) {
        //Trying to remove get parameters
        if (window.history && window.history.replaceState) {
            var currentPageHref = window.location.href;
            var originalPageHref = currentPageHref.substr(0, currentPageHref.indexOf("JIRAIssuesCreated") - 1);
            window.history.replaceState({}, document.title, originalPageHref);
        }
        var $contentMessage = $msgPanel.find("#jira-content-message-panel-error-warning");
        var $viewMoreLink = $msgPanel.find("#jira-content-message-panel-view-more-link");
        $viewMoreLink.click(function(e) {
            e.preventDefault();
            $viewMoreLink.hide();
            $contentMessage.show();
        });
        //Hide the success message panel after 10 seconds. Otherwise let user manually dismiss it.
        if ($msgPanel.hasClass("success")) {
            setTimeout(function() { $msgPanel.hide(); }, 10000);
        }
    }

    // check if plugin Confluence-highlight-action is enabled
    Confluence && Confluence.HighlightAction && Confluence.HighlightAction.registerButtonHandler(PLUGIN_KEY, {
        onClick: function(selectionObject) {

            var $target;

            // If the resources aren't already loaded, show a loading dialog
            if (!loaded) {
                var displayFn = function(content, trigger, showPopup) {
                    content.html('<span class="aui-icon aui-icon-wait"></span> ' + LOADING_TEXT);
                    showPopup();
                    return false;
                };

                $target = $("<div>");
                Confluence.CreateJiraContent.Dialogs.appendDialogTarget(selectionObject.area.average, $target);

                dialog = Confluence.ScrollingInlineDialog($target, 'create-issue-loading-dialog', displayFn, {});
                dialog.show();

                loaded = true;
            }

            // CONFDEV-34854
            // Pull in web resources and fire up the dialog once they're loaded
            WRM.require(WEB_RESOURCE_KEY)
                .done(function () {
                    if (Confluence.CreateJiraContent.FeatureDiscovery.shouldShowFeatureDiscovery()) {
                        Confluence.CreateJiraContent.Dialogs.showFeatureDiscoveryDialog(selectionObject);
                    } else {
                        Confluence.CreateJiraContent.Dialogs.showCreateIssueDialog(selectionObject);
                    }

                    if (typeof $target !== "undefined") {
                        $target.remove();
                    }
                });
        },
        shouldDisplay: Confluence.HighlightAction.WORKING_AREA.MAINCONTENT_ONLY // this plugin should be only works on Main Content
    });

    Confluence.CreateJiraContent = {
        Dialogs: {}
    };

    Confluence.CreateJiraContent.Dialogs.appendDialogTarget = function(targetDimensions, $target) {
        Confluence.DocThemeUtils.appendAbsolutePositionedElement($target);
        $target.css({
            top: targetDimensions.top,
            height: targetDimensions.height,
            left: targetDimensions.left,
            width: targetDimensions.width,
            "z-index": -9999,
            position: 'absolute'
        }).addClass('confluence-jira-content-dialog-target');
    };
});