define('confluence/cjc/common/form-helper', [
    'jquery',
    'ajs'
],
function(
    $,
    AJS
) {
    'use strict';

    var MAX_LENGTH = 255;
    var hellip = '\u2026';

    return {
        trunc: function(txt) {
            return txt.length <= MAX_LENGTH ? txt : txt.substr(0, MAX_LENGTH - 1) + hellip;
        },

        isCutLongText: function(txt) {
            if (txt.length >= MAX_LENGTH) {
                return true;
            }
            return false;
        },

        removeLineBreaksAndTruncate: function(txt) {
            var removedBreakLineText = txt.replace(/\n|\r|\r\n/g, ' ');
            return this.trunc(removedBreakLineText);
        },

        /**
         * By default, press ESC button will reset form in IE, it causes some problem with select2
         * (value change to default but text holder is still display the old value)
         * this function will prevent form reset in IE. But still keep features: close selectbox, close dialog by using ESC
         */
        preventEscKeyResetFormInIE: function($wrapper) {
            var ESC_KEY = 27;

            if ($.browser && $.browser.msie) {
                $wrapper.find('input, textarea').keydown(function(e) {
                    if (e.keyCode === ESC_KEY) {
                        return false;
                    }
                });
            }
        },
    };
});
