(function ($) {
    'use strict';

    Confluence.InlineTasks = Confluence.InlineTasks || {};
    Confluence.InlineTasks.TasksReport = Confluence.InlineTasks.TasksReport || {};

    var labelMap = {
        'blank.complete.title': AJS.I18n.getText("task.report.blank.title"),
        'blank.complete.desc': AJS.I18n.getText("task.report.blank.nocompletetask"),
        'blank.incomplete.title': AJS.I18n.getText("task.report.blank.title"),
        'blank.incomplete.desc': AJS.I18n.getText("task.report.blank.noincompletetask")
    };

    //public 'renderBlankExperiences' method for testable
    Confluence.InlineTasks.TasksReport.renderBlankExperiences = function ($container, status) {
        //default status is incomplete
        if (!status) {
            status = "incomplete";
        }
        var title = labelMap['blank.' + status + '.title'],
            desc = labelMap['blank.' + status + '.desc'];

        var html = Confluence.UI.Components.BlankPlaceholderBox.Templates.blankBox({
            blankTitle: title,
            blankDescription: desc,
            customClass: status + ' tasks-report-blank' //for testable purpose
        });

        $container.html(html);
    };

})(AJS.$);

