(function($){
    "use strict";

    var labelMap = {
        'blank.assignedToMe-complete.title': '.assignedToMe-complete',
        'blank.assignedToMe-complete.desc': '.assignedToMe-complete',
        'blank.assignedToMe-incomplete.title': '.assignedToMe-incomplete',
        'blank.assignedToMe-incomplete.desc': '.assignedToMe-incomplete',
        'blank.createdByMe-complete.title': '.createdByMe-complete',
        'blank.createdByMe-complete.desc': '.createdByMe-complete',
        'blank.createdByMe-incomplete.title': '.createdByMe-incomplete',
        'blank.createdByMe-incomplete.desc': '.createdByMe-incomplete'
    };

    AJS.test.require(["com.atlassian.confluence.plugins.confluence-inline-tasks:my-tasks-blank-exp-resources"], function () {
        var module = QUnit.module;
        var test = QUnit.test;
        var $taskContainer;
        $("#qunit-fixture").append("<div id='task-container-test'>");
        module("test method 'renderBlankExperiences'", {
            setup: function () {
                $taskContainer = $('#task-container-test');
            },
            teardown: function () {
                $taskContainer.empty();
            }
        }, function () {
            test("test assignedToMe and complete", function(assert) {
                Confluence.InlineTasks.MyTasks.renderBlankExperiences("assignedToMe", "complete", $taskContainer, labelMap);
                assert.ok($taskContainer.find(labelMap['blank.assignedToMe-complete.title']).length > 0);
            });

            test("test assignedToMe and incomplete", function(assert) {
                Confluence.InlineTasks.MyTasks.renderBlankExperiences("assignedToMe", "incomplete", $taskContainer, labelMap);
                assert.ok($taskContainer.find(labelMap['blank.assignedToMe-incomplete.title']).length > 0);
            });

            test("test createdByMe and complete", function(assert) {
                Confluence.InlineTasks.MyTasks.renderBlankExperiences("createdByMe", "complete", $taskContainer, labelMap);
                assert.ok($taskContainer.find(labelMap['blank.createdByMe-complete.title']).length > 0);
            });

            test("test createdByMe and incomplete", function(assert) {
                Confluence.InlineTasks.MyTasks.renderBlankExperiences("createdByMe", "incomplete", $taskContainer, labelMap);
                assert.ok($taskContainer.find(labelMap['blank.createdByMe-incomplete.title']).length > 0);
            });
        });
    });
}(AJS.$));