/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.upgradetask;

import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.service.InlineTaskService;
import com.atlassian.confluence.plugins.tasklist.upgradetask.StorageToAoMigrationLatch;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageToAoMigrationTaskInserter
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StorageToAoMigrationTaskInserter.class);
    private static final int BATCH_SIZE = 100;
    private final TransactionTemplate transactionTemplate;
    private final BlockingQueue<Task> tasksMigrationQueue;
    private final InlineTaskService inlineTaskService;
    private final AtomicInteger migratedTaskCounter;
    private final StorageToAoMigrationLatch latch;

    public StorageToAoMigrationTaskInserter(TransactionTemplate transactionTemplate, BlockingQueue<Task> tasksMigrationQueue, InlineTaskService inlineTaskService, AtomicInteger migratedTaskCounter, StorageToAoMigrationLatch latch) {
        this.transactionTemplate = transactionTemplate;
        this.tasksMigrationQueue = tasksMigrationQueue;
        this.inlineTaskService = inlineTaskService;
        this.migratedTaskCounter = migratedTaskCounter;
        this.latch = latch;
    }

    @Override
    public void run() {
        try {
            Task lastTaskFromQueue;
            AtomicReference interrupted = new AtomicReference();
            while ((lastTaskFromQueue = (Task)this.transactionTemplate.execute(() -> {
                Task task = null;
                for (int i = 0; i < 100; ++i) {
                    try {
                        task = this.getTaskFromQueue();
                        if (task == null) {
                            return null;
                        }
                        this.inlineTaskService.create(task);
                        this.migratedTaskCounter.incrementAndGet();
                        continue;
                    }
                    catch (InterruptedException e) {
                        interrupted.set(e);
                        return null;
                    }
                }
                return task;
            })) != null && interrupted.get() == null) {
            }
            if (interrupted.get() != null) {
                log.warn("Task inserter was interrupted. Aborting.");
                return;
            }
            log.debug("Finished inserting tasks into Active Objects store.");
        }
        finally {
            this.latch.taskInserterDone();
        }
    }

    private Task getTaskFromQueue() throws InterruptedException {
        Task task;
        while ((task = this.tasksMigrationQueue.poll(10L, TimeUnit.MILLISECONDS)) == null && !this.latch.isTaskExtractionComplete()) {
        }
        return task;
    }

    static {
        LogManager.getLogger(StorageToAoMigrationTaskInserter.class).setLevel(Level.INFO);
    }
}

