/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.upgradetask;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.content.render.xhtml.migration.ContentWithTasksWorkSource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.upgradetask.StorageToAoMigrationLatch;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageToAoMigrationPageFinder
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StorageToAoMigrationPageFinder.class);
    private static final int BATCH_SIZE = 100;
    private final PageManager pageManager;
    private final BlockingQueue<ContentEntityObject> pageQueue;
    private final TransactionTemplate transactionTemplate;
    private final StorageToAoMigrationLatch latch;
    private final ActiveObjects activeObjects;

    public StorageToAoMigrationPageFinder(BlockingQueue<ContentEntityObject> pageQueue, PageManager pageManager, TransactionTemplate transactionTemplate, StorageToAoMigrationLatch latch, ActiveObjects activeObjects) {
        this.pageManager = pageManager;
        this.pageQueue = pageQueue;
        this.transactionTemplate = transactionTemplate;
        this.latch = latch;
        this.activeObjects = activeObjects;
    }

    @Override
    public void run() {
        try {
            this.activeObjects.moduleMetaData().awaitInitialization();
            ContentWithTasksWorkSource workSource = new ContentWithTasksWorkSource(this.pageManager, 100);
            int numberOfPagesWithTasks = this.getPageCountInTransaction(workSource);
            log.info("Starting migration of tasks in {} pages to Active Objects.", (Object)numberOfPagesWithTasks);
            this.readFromWorkSourceToPageQueue(workSource);
            log.debug("Finished finding pages with tasks.");
        }
        catch (InterruptedException e) {
            log.warn("Page finder was interrupted. Aborting.", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.warn("Page finder was interrupted. Aborting", (Throwable)e);
        }
        finally {
            this.latch.pageFinderDone();
        }
    }

    private void readFromWorkSourceToPageQueue(ContentWithTasksWorkSource workSource) throws InterruptedException {
        AtomicInteger batchNumber = new AtomicInteger(1);
        while (workSource.hasMoreBatches()) {
            List<ContentEntityObject> batch = this.getBatchOfPagesInTransaction(workSource);
            log.debug("Read {} pages in batch {} of {}.", new Object[]{batch.size(), batchNumber.get(), workSource.numberOfBatches()});
            for (ContentEntityObject page : batch) {
                this.pageQueue.put(page);
            }
            batchNumber.incrementAndGet();
        }
    }

    private List<ContentEntityObject> getBatchOfPagesInTransaction(final ContentWithTasksWorkSource workSource) {
        return (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<ContentEntityObject>>(){

            public List<ContentEntityObject> doInTransaction() {
                List batchOfPages = workSource.getBatch();
                StorageToAoMigrationPageFinder.this.workAroundHibernateWeirdness(batchOfPages);
                return batchOfPages;
            }
        });
    }

    private void workAroundHibernateWeirdness(List<ContentEntityObject> batchOfPages) {
        for (ContentEntityObject ceo : batchOfPages) {
            if (!(ceo instanceof Page)) continue;
            Page page = (Page)ceo;
            try {
                Hibernate.initialize((Object)page.getSpace());
            }
            catch (HibernateException e) {
                log.warn("Failed to initialise page {}", (Object)page);
            }
        }
    }

    private Integer getPageCountInTransaction(final ContentWithTasksWorkSource workSource) {
        return (Integer)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction() {
                return workSource.getTotalSize();
            }
        });
    }

    static {
        LogManager.getLogger(StorageToAoMigrationPageFinder.class).setLevel(Level.INFO);
    }

    private static final class SentinelCeo
    extends ContentEntityObject {
        private SentinelCeo() {
        }

        public String getType() {
            return null;
        }

        public String getUrlPath() {
            return null;
        }

        public String getNameForComparison() {
            return null;
        }
    }
}

