/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.upgradetask;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.plugins.tasklist.ao.AOInlineTask;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteInvalidTasksUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(DeleteInvalidTasksUpgradeTask.class);
    private static final Class<AOInlineTask> AO_TASK_TYPE = AOInlineTask.class;
    private final ActiveObjects ao;

    @Autowired
    public DeleteInvalidTasksUpgradeTask(ActiveObjects ao) {
        this.ao = ao;
    }

    public int getBuildNumber() {
        return 2;
    }

    public String getShortDescription() {
        return "Removes invalid tasks inserted by the StorageToAoMigrationUpgradeTask";
    }

    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-inline-tasks";
    }

    public Collection<Message> doUpgrade() throws Exception {
        int numRowsDeleted = this.ao.deleteWithSQL(AO_TASK_TYPE, "ID = -1", new Object[0]);
        log.info("Deleted {} invalid tasks", (Object)numRowsDeleted);
        return Collections.emptyList();
    }
}

