/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.service;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.concurrent.Lock;
import com.atlassian.confluence.concurrent.LockFactory;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XMLEventFactoryProvider;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.XmlOutputFactory;
import com.atlassian.confluence.content.render.xhtml.storage.inlinetask.StorageInlineTaskConstants;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.TaskStatus;
import com.atlassian.confluence.plugins.tasklist.ao.dao.InlineTaskDao;
import com.atlassian.confluence.plugins.tasklist.search.SearchTaskParameters;
import com.atlassian.confluence.plugins.tasklist.service.InlineTaskResponse;
import com.atlassian.confluence.plugins.tasklist.service.InlineTaskService;
import com.atlassian.confluence.plugins.tasklist.service.TaskPaginationService;
import com.atlassian.confluence.plugins.tasklist.transformer.TaskVisitor;
import com.atlassian.confluence.plugins.tasklist.transformer.helper.XMLSink;
import com.atlassian.confluence.plugins.tasklist.transformer.xml.ParsingContext;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.diffs.MergeResult;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.user.User;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import java.io.StringReader;
import java.time.Duration;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultInlineTaskService
implements InlineTaskService {
    private static final Logger log = LoggerFactory.getLogger(DefaultInlineTaskService.class);
    private final PageManager pageManager;
    private final DraftManager draftManager;
    private final XmlEventReaderFactory readerFactory;
    private final XMLEventFactory xmlEventFactory;
    private final XmlOutputFactory writerFactory;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final PermissionManager permissionManager;
    private final LockFactory lockFactory;
    private final InlineTaskDao inlineTaskDao;
    private final PaginationService paginationService;
    private final UserAccessor userAccessor;
    private final DarkFeatureManager darkFeatureManager;
    private final Supplier<StableReadExternalCache<String>> lastModifiedTasks;
    private static final String CACHE_NAME = DefaultInlineTaskService.class.getName() + ".lastModifiedTasks";
    private static final String NOTIFICATION_BATCH_DARKFEATURE = "notification.batch";
    private static final String INLINE_TASK_COMPLETED_KEY = "inline.task.completed";
    private static final String INLINE_TASK_UNCOMPLETED_KEY = "inline.task.uncompleted";

    @Autowired
    public DefaultInlineTaskService(PageManager pageManager, DraftManager draftManager, LockFactory lockFactory, XmlEventReaderFactory inFactory, XMLEventFactoryProvider xmlEventFactory, @Qualifier(value="xmlOutputFactory") XmlOutputFactory outFactory, @Qualifier(value="i18NBeanFactory") I18NBeanFactory i18nfactory, LocaleManager lm, PermissionManager pm, InlineTaskDao inlineTaskDao, PaginationService paginationService, UserAccessor userAccessor, VCacheFactory cacheFactory, DarkFeatureManager darkFeatureManager) {
        this.pageManager = pageManager;
        this.draftManager = draftManager;
        this.readerFactory = inFactory;
        this.inlineTaskDao = inlineTaskDao;
        this.paginationService = paginationService;
        this.userAccessor = userAccessor;
        this.darkFeatureManager = darkFeatureManager;
        this.xmlEventFactory = xmlEventFactory.getXmlEventFactory();
        this.writerFactory = outFactory;
        this.i18NBeanFactory = i18nfactory;
        this.localeManager = lm;
        this.permissionManager = pm;
        this.lockFactory = lockFactory;
        this.lastModifiedTasks = Lazy.supplier(() -> cacheFactory.getStableReadExternalCache(CACHE_NAME, MarshallerFactory.stringMarshaller(), new ExternalCacheSettingsBuilder().defaultTtl(Duration.ofSeconds(10L)).build()));
    }

    @Override
    public InlineTaskResponse setTaskStatus(ContentEntityObject cob, final String taskId, final TaskStatus newStatus, PageUpdateTrigger trigger) throws NotPermittedException {
        final AtomicBoolean found = new AtomicBoolean(false);
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)cob)) {
            throw new NotPermittedException("Object not found, or you lack sufficent permission to view/edit the entity");
        }
        if (cob == null) {
            throw new IllegalArgumentException("Invalid contentId, or not sufficent permissions");
        }
        StringReader reader = new StringReader(cob.getBodyAsString());
        DefaultConversionContext ctx = new DefaultConversionContext((RenderContext)cob.toPageContext());
        try {
            String xmlBody = TaskVisitor.transformTask(this.readerFactory, this.writerFactory, this.xmlEventFactory, reader, (ConversionContext)ctx, 0L, new TaskVisitor.VisitTask(){

                @Override
                public boolean consumeTaskIfHandled(ParsingContext context, XMLEventReader xmlReader, XMLSink xmlWriter) throws XMLStreamException {
                    while (xmlReader.hasNext()) {
                        if (xmlReader.peek().isStartElement() && StorageInlineTaskConstants.TASK_ELEMENT.equals(xmlReader.peek().asStartElement().getName())) {
                            boolean foundMatch = false;
                            xmlWriter.add(xmlReader.nextEvent());
                            while (xmlReader.hasNext()) {
                                XMLEvent nextEvent = xmlReader.peek();
                                if (nextEvent.isStartElement() && StorageInlineTaskConstants.TASK_ID_ELEMENT.equals(nextEvent.asStartElement().getName())) {
                                    foundMatch = this.handleIdAndCheckIfMatch(xmlReader, xmlWriter);
                                    continue;
                                }
                                if (nextEvent.isStartElement() && StorageInlineTaskConstants.TASK_STATUS_ELEMENT.equals(nextEvent.asStartElement().getName())) {
                                    this.handleStatus(context, xmlReader, xmlWriter, foundMatch);
                                    continue;
                                }
                                xmlWriter.add(xmlReader.nextEvent());
                            }
                            return true;
                        }
                        XMLEvent event = xmlReader.nextEvent();
                        xmlWriter.add(event);
                        if (!event.isEndElement() || !StorageInlineTaskConstants.TASK_ELEMENT.equals(event.asEndElement().getName())) continue;
                        break;
                    }
                    return true;
                }

                private boolean handleIdAndCheckIfMatch(XMLEventReader xmlReader, XMLSink xmlWriter) throws XMLStreamException {
                    boolean foundMatch = false;
                    xmlWriter.add(xmlReader.nextEvent());
                    XMLEvent taskIdEvent = xmlReader.nextEvent();
                    if (taskIdEvent.isCharacters() && taskIdEvent.asCharacters().getData().equals(taskId)) {
                        foundMatch = true;
                        found.set(true);
                    }
                    xmlWriter.add(taskIdEvent);
                    xmlWriter.add(xmlReader.nextEvent());
                    return foundMatch;
                }

                private void handleStatus(ParsingContext context, XMLEventReader xmlReader, XMLSink xmlWriter, boolean matchFound) throws XMLStreamException {
                    String taskStatus;
                    xmlWriter.add(xmlReader.nextEvent());
                    XMLEvent taskStatusEvent = xmlReader.nextEvent();
                    if (matchFound && !(taskStatus = taskStatusEvent.asCharacters().getData()).equals(this.storageEquivalent(newStatus))) {
                        taskStatusEvent = context.getEventFactory().createCharacters(this.storageEquivalent(newStatus));
                    }
                    xmlWriter.add(taskStatusEvent);
                    xmlWriter.add(xmlReader.nextEvent());
                }

                private String storageEquivalent(TaskStatus status) {
                    if (status == TaskStatus.CHECKED) {
                        return StorageInlineTaskConstants.TASK_STATUS_COMPLETE;
                    }
                    return StorageInlineTaskConstants.TASK_STATUS_INCOMPLETE;
                }
            });
            if (found.get()) {
                I18NBean bean = this.i18NBeanFactory.getI18NBean(this.localeManager.getSiteDefaultLocale());
                String versionComment = this.darkFeatureManager.isFeatureEnabledForAllUsers(NOTIFICATION_BATCH_DARKFEATURE) ? null : (newStatus.equals((Object)TaskStatus.CHECKED) ? bean.getText(INLINE_TASK_COMPLETED_KEY) : bean.getText(INLINE_TASK_UNCOMPLETED_KEY));
                return this.updatePage(cob, taskId, xmlBody, versionComment, trigger);
            }
        }
        catch (XhtmlException e) {
            log.error(e.toString(), (Throwable)e);
            throw new RuntimeException("Internal error", e);
        }
        catch (CloneNotSupportedException e) {
            log.error(e.toString(), (Throwable)e);
        }
        return InlineTaskResponse.TASK_NOT_FOUND;
    }

    @Override
    public Task find(long globalId) {
        return this.inlineTaskDao.find(globalId);
    }

    @Override
    public Task find(long contentId, long id) {
        return this.inlineTaskDao.find(contentId, id);
    }

    @Override
    public Set<Long> findTaskIdsByContentId(long contentId) {
        return this.inlineTaskDao.findTaskIdsByContentId(contentId);
    }

    @Override
    public Task create(Task task) {
        return this.inlineTaskDao.create(task);
    }

    @Override
    public Task update(Task task, String performerName, boolean hasStatusChanged, boolean hasBodyChanged) {
        Task updatedTask = this.updateTask(task);
        if (updatedTask == null) {
            return null;
        }
        if (hasStatusChanged) {
            updatedTask = task.getStatus() == TaskStatus.CHECKED ? new Task.Builder(updatedTask).withCompleteUser(performerName).withCompleteDate(new Date()).build() : new Task.Builder(updatedTask).withCompleteUser(null).withCompleteDate(null).withUpdateDate(new Date()).build();
        }
        if (hasBodyChanged) {
            updatedTask = new Task.Builder(updatedTask).withUpdateDate(new Date()).build();
        }
        return this.inlineTaskDao.update(updatedTask);
    }

    @Override
    public void delete(long globalId) {
        this.inlineTaskDao.delete(globalId);
    }

    @Override
    public void delete(long contentId, long id) {
        this.inlineTaskDao.delete(contentId, id);
    }

    private Task updateTask(Task task) {
        Task persistedTask = this.inlineTaskDao.find(task.getContentId(), task.getId());
        if (persistedTask != null) {
            return new Task.Builder(persistedTask).withContentId(task.getContentId()).withStatus(task.getStatus()).withTitle(task.getTitle()).withBody(task.getBody()).withAssignee(task.getAssignee()).withDueDate(task.getDueDate()).build();
        }
        return null;
    }

    @Override
    public void delete(Task task) {
        this.inlineTaskDao.delete(task.getContentId(), task.getId());
    }

    @Override
    public void deleteBySpaceId(long spaceId) {
        this.inlineTaskDao.deleteBySpaceId(spaceId);
    }

    @Override
    public PageResponse<Task> searchTasks(SearchTaskParameters params) {
        ConfluenceUser confluenceUser = this.getAuthenticatedUser();
        int startPage = params.getPageIndex() * params.getPageSize();
        int endPage = startPage + params.getPageSize() * params.getDisplayedPages();
        SimplePageRequest pageRequest = new SimplePageRequest(startPage, endPage);
        PageResponse<Task> response = this.inlineTaskDao.searchTask(params, new TaskPaginationService(confluenceUser, this.permissionManager, this.pageManager, this.paginationService, this.userAccessor), (PageRequest)pageRequest);
        Integer totalPages = 7;
        if (!response.hasMore()) {
            int additionalPages = (int)Math.ceil((double)response.size() / (double)params.getPageSize());
            totalPages = params.getPageIndex() + additionalPages;
        }
        params.setTotalPages(totalPages);
        return response;
    }

    @Override
    public long countAllTasks() {
        return this.inlineTaskDao.countAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InlineTaskResponse updatePage(ContentEntityObject page, String taskId, String newBody, String versionComment, PageUpdateTrigger trigger) throws CloneNotSupportedException {
        Draft draft = new Draft();
        draft.setPageId(page.getIdAsString());
        draft.setPageVersion(page.getVersion());
        draft.setBodyAsString(newBody);
        while (true) {
            Lock lock = this.lockFactory.getLock("InlineTaskService.updatePage." + page.getIdAsString());
            lock.lock();
            try {
                this.pageManager.refreshContentEntity(page);
                if (!this.draftManager.isMergeRequired(draft) || this.isTaskIdInCache(taskId, page)) {
                    ContentEntityObject originalPage = (ContentEntityObject)page.clone();
                    VCacheUtils.fold((CompletionStage)((StableReadExternalCache)this.lastModifiedTasks.get()).put(page.getIdAsString(), (Object)taskId, PutPolicy.PUT_ALWAYS), Function.identity(), failEx -> {
                        log.warn("Cache put failed.", failEx);
                        return false;
                    });
                    page.setVersionComment(versionComment);
                    page.setBodyAsString(draft.getBodyAsString());
                    this.pageManager.saveContentEntity(page, originalPage, (SaveContext)new DefaultSaveContext(false, true, false, trigger));
                    InlineTaskResponse inlineTaskResponse = InlineTaskResponse.SUCCESS;
                    return inlineTaskResponse;
                }
            }
            finally {
                lock.unlock();
            }
            MergeResult mergeResult = this.draftManager.mergeContent(draft);
            if (mergeResult.hasConflicts()) {
                return InlineTaskResponse.MERGE_CONFLICT;
            }
            draft.setPageVersion(page.getVersion());
            draft.setBodyAsString(mergeResult.getMergedContent());
        }
    }

    private boolean isTaskIdInCache(String taskId, ContentEntityObject page) {
        return StringUtils.equals((CharSequence)taskId, (CharSequence)((CharSequence)VCacheUtils.fold((CompletionStage)((StableReadExternalCache)this.lastModifiedTasks.get()).get(page.getIdAsString()), success -> success.orElse(""), failEx -> {
            log.warn("Cache get failed.", failEx);
            return "";
        })));
    }

    private ConfluenceUser getAuthenticatedUser() {
        return AuthenticatedUserThreadLocal.get();
    }
}

