/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.notification;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.core.PluginDataSourceFactory;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugins.tasklist.notification.NotificationEmailFactory;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import java.util.function.Predicate;
import javax.activation.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationEmailFactoryImpl
implements NotificationEmailFactory {
    private static final String PAGE_ICON_IMAGE_PATH = "/images/icons/contenttypes/page_16.png";
    private static final String BLOG_ICON_IMAGE_PATH = "/images/icons/contenttypes/blog_post_16.png";
    private DataSourceFactory imageDataSourceFactory;

    @Autowired
    public NotificationEmailFactoryImpl(DataSourceFactory imageDataSourceFactory) {
        this.imageDataSourceFactory = imageDataSourceFactory;
    }

    @Override
    public PreRenderedMailNotificationQueueItem create(ContentEntityObject contentEntityObject, ConfluenceUser recipient, ConfluenceUser sender, String templateLocation, String templateName, String subject, NotificationContext context) {
        PreRenderedMailNotificationQueueItem.Builder builder = PreRenderedMailNotificationQueueItem.with((User)recipient, (String)templateName, (String)subject).andSender((User)sender).andTemplateLocation(templateLocation).andContext(context.getMap());
        if ("blogpost".equals(contentEntityObject.getType())) {
            context.addTemplateImage(this.imageDataSourceFactory.getServletContainerResource(BLOG_ICON_IMAGE_PATH, "blogpost-icon"));
        } else if ("page".equals(contentEntityObject.getType())) {
            context.addTemplateImage(this.imageDataSourceFactory.getServletContainerResource(PAGE_ICON_IMAGE_PATH, "page-icon"));
        }
        builder.andRelatedBodyParts((Iterable)context.getTemplateImageDataSources());
        builder.andRelatedBodyParts(this.imagesUsedByChromeTemplate());
        return builder.render();
    }

    private Iterable<DataSource> imagesUsedByChromeTemplate() {
        return (Iterable)((PluginDataSourceFactory)this.imageDataSourceFactory.createForPlugin("com.atlassian.confluence.plugins.confluence-email-resources").get()).getResourcesFromModules("chrome-template", (Predicate)PluginDataSourceFactory.FilterByType.IMAGE).get();
    }
}

