define('confluence/ic/view/navigation',
    [
        'backbone'
    ], function(
        Backbone
    ) {

    "use strict";

    var NavigationView = Backbone.View.extend({
        tagName: 'div',

        events: {
            "click #ic-nav-previous" : "showPrevious",
            "click #ic-nav-next" : "showNext"
        },

        template: Confluence.Templates.IC.navigation,

        initialize: function() {
            this.collection = this.model.collection;
            this.listenTo(this.collection, "change:resolveProperties", this.onResolveToggle);
            // if sidebar is displaying comment, make sure at least one other valid comment exists to navigate to
            this.disabled = this.collection.getCommentsOnPageCount() <= 1;
            this.listenTo(Backbone, "ic:show-previous", this.showPrevious);
            this.listenTo(Backbone, "ic:show-next", this.showNext);
        },

        render: function() {
            this.$el.html(this.template({
                disabled: this.disabled,
                showIndex: !(this.model.isResolved() || this.model.get('deleted')),
                index: this.collection.getActiveIndexWithinPageComments() + 1,
                size: this.collection.getCommentsOnPageCount()
            }));

            return this;
        },

        onResolveToggle: function() {
            this.disabled = this.collection.getCommentsOnPageCount() <= 1;
            this.render();
        },

        showPrevious : function() {
            if (this.disabled) {
                return;
            }
            var prevComment = this.collection.getPrevCommentOnPage();
            if (prevComment != null) {
                Backbone.trigger("ic:view", prevComment, 'nav');
            }
        },

        showNext : function() {
            if (this.disabled) {
                return;
            }
            var nextComment = this.collection.getNextCommentOnPage();
            if (nextComment != null) {
                Backbone.trigger("ic:view", nextComment, 'nav');
            }
        }
    });

    return NavigationView;
});