define('confluence/ic/likes/likes-manager',
    [
        'underscore'
    ],
    function (
        _
    ) {

    "use strict";

    var LikesManager = {

        init: function (likes) {
            this.likesCache = _.clone(likes) || {};
        },

        getLikes: function (contentId) {
            if (this.likesCache && this.likesCache[contentId]) {
                var likes = _.map(this.likesCache[contentId].likes, function (like) {
                    return { username: like.user.name };
                });
                return likes;
            }
            return null;
        },

        add: function(contentId, name) {
            if (!this.likesCache[contentId]) {
                this.likesCache[contentId] = {likes : []};
            }
            this.likesCache[contentId].likes.push({user : {name: name}});
        },

        remove: function(contentId, name) {
            if (this.likesCache[contentId] && this.likesCache[contentId].likes) {
                var likes = _.reject(this.likesCache[contentId].likes, function(like) {
                    return like.user.name === name;
                });
                this.likesCache[contentId].likes = likes;
            }
        },

        isLikable: function() {
            return this.likesCache !== undefined;
        }
    };

    return LikesManager;
});