define('confluence/ic/util/text-highlighter', [
    'jquery'
], function($) {
    "use strict";

    /*
     * A wrapped version of jquery highlighter plugin with customizations
     * It can be instantiated anywhere
     */
    var CURRENT_HIGHLIGHT_SELECTOR = 'ic-current-selection';

    function TextHighlighter() {
        $.textHighlighter.createWrapper = function(options) {
            return $('<span></span>').addClass(options.highlightedClass);
        };
        this.$el = $('#content .wiki-content').first();

        if (this.$el.length > 0) {
            this.$el.textHighlighter({
                highlightedClass: CURRENT_HIGHLIGHT_SELECTOR
            });
        }
    }

    TextHighlighter.prototype.highlight = function(range) {
        if (this.$el.length === 0) {
            return;
        }
        var $highlightNodes = $(this.$el.getHighlighter().doHighlight(range));
        return this.$el.getHighlighter().serializeHighlights($highlightNodes);
    };

    TextHighlighter.prototype.removeHighlight = function() {
        if (this.$el.length === 0) {
            return;
        }
        this.$el.getHighlighter().removeHighlights();
        return this;
    };

    /**
     * Deserializes highlights from stringified JSON given as parameter.
     */
    TextHighlighter.prototype.deserializeHighlights = function(json, markerRef) {
        if (this.$el.length === 0) {
            return;
        }
        var wrapper = '<span class="inline-comment-marker" data-ref="' + markerRef + '"></span>';
        return this.$el.getHighlighter().deserializeHighlights(json, wrapper);
    };

    return TextHighlighter;
});