define('confluence/ic/model/reply',
    [
        'jquery',
        'backbone',
        'ajs',
        'confluence/ic/util/utils',
    ],
    function(
        $,
        Backbone,
        AJS,
        Utils
    ) {

    "use strict";

    var Reply = Backbone.Model.extend({

        defaults: {
            authorDisplayName: Utils.getAuthorDisplayName(),
            authorUserName: AJS.Meta.get('remote-user'),
            authorAvatarUrl: AJS.contextPath() + AJS.Meta.get('current-user-avatar-url'),
            body: "",
            commentId: "0",
            hasDeletePermission: true,
            hasEditPermission: !!AJS.Meta.get('remote-user')
        },

        urlRoot: function() {
            return AJS.contextPath() + "/rest/inlinecomments/1.0/comments/" + this.get("commentId") + "/replies";
        },

        sync: function(method, model, options) {
            options = options || {};
            if (method === 'create') {
                options.url = this.urlRoot() +  '?containerId=' + AJS.Meta.get('latest-page-id');
            }
            return Backbone.sync.call(this, method, model, options);
        },

        validate: function () {
            if (!this.get("body")) {
                return true;
            }
        }
    });

    return Reply;
});
