/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spi.impl;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.spi.impl.AbstractHipChatLinkAccessManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.User;
import com.sun.jersey.spi.container.ContainerRequest;
import io.atlassian.fugue.Option;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.MultivaluedMap;

public class ConfluenceHipChatLinkAccessManager
extends AbstractHipChatLinkAccessManager {
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;

    public ConfluenceHipChatLinkAccessManager(UserManager userManager, PermissionManager permissionManager, SpaceManager spaceManager, UserAccessor userAccessor) {
        super(userManager);
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
    }

    public boolean hasAccess(UserProfile userProfile, HipChatLink link, ContainerRequest request) {
        if (super.hasAccess(userProfile, link, request)) {
            return true;
        }
        Option<Space> space = this.getSpace(request);
        return this.hasAccess(userProfile, space);
    }

    private boolean hasAccess(UserProfile userProfile, Option<Space> space) {
        if (space.isEmpty()) {
            return false;
        }
        User user = this.getUserByProfile(userProfile);
        return this.isSpaceAdmin(user, (Space)space.get());
    }

    public boolean hasAccess(UserProfile userProfile, ContainerRequest request) {
        if (super.hasAccess(userProfile, request)) {
            return true;
        }
        Option<Space> space = this.getSpace(request);
        return this.hasAccess(userProfile, space);
    }

    public boolean hasAccess(UserProfile userProfile, HipChatLink link, HttpServletRequest request) {
        if (super.hasAccess(userProfile, link, request)) {
            return true;
        }
        Option<Space> space = this.getSpace(request);
        return this.hasAccess(userProfile, space);
    }

    public boolean hasAccess(UserProfile userProfile, HttpServletRequest request) {
        if (super.hasAccess(userProfile, request)) {
            return true;
        }
        Option<Space> space = this.getSpace(request);
        return this.hasAccess(userProfile, space);
    }

    private Option<Space> getSpace(ContainerRequest request) {
        MultivaluedMap params = request.getQueryParameters();
        String spaceKey = (String)params.getFirst((Object)"key");
        return this.getSpaceFromKey(spaceKey);
    }

    private Option<Space> getSpace(HttpServletRequest request) {
        HttpSession session;
        Boolean sentFromSpace;
        String spaceKey = request.getParameter("key");
        if (spaceKey == null && (sentFromSpace = (Boolean)(session = request.getSession()).getAttribute("hipchat.integration.attribute.from.space")) != null && sentFromSpace.booleanValue()) {
            spaceKey = (String)session.getAttribute("hipchat.integration.attribute.space.key");
        }
        return this.getSpaceFromKey(spaceKey);
    }

    private Option<Space> getSpaceFromKey(String spaceKey) {
        if (spaceKey == null) {
            return Option.none();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        return Option.option((Object)space);
    }

    private boolean isSpaceAdmin(User user, Space space) {
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space);
    }

    private User getUserByProfile(UserProfile userProfile) {
        return this.userAccessor.getExistingUserByKey(userProfile.getUserKey());
    }
}

