/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.util;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomMapping;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomMappingManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConfluenceGlanceUpdateMetadata;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Condition;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Glance;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Icon;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Name;
import com.atlassian.hipchat.api.connect.descriptor.extensions.WebPanel;
import com.atlassian.hipchat.api.glances.GlanceData;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Calendar;
import java.util.Date;

public final class ConfluenceConnectUtil {
    private static final String DEFAULT_GLANCE_TITLE = "Confluence";

    private ConfluenceConnectUtil() {
    }

    public static Glance buildGlanceDefinition(String roomId, SettingsManager settingsManager, EntityToRoomMappingManager entityToRoomMappingManager, SpaceManager spaceManager) {
        Settings settings = settingsManager.getGlobalSettings();
        String glanceTitle = ConfluenceConnectUtil.buildGlanceTitle(roomId, settingsManager, entityToRoomMappingManager, spaceManager);
        String baseUrl = settings.getBaseUrl();
        String glanceKey = ConfluenceConnectUtil.buildGlanceKey(roomId);
        String iconUrl = baseUrl + "/download/resources/com.atlassian.confluence.plugins.confluence-hipchat-integration-plugin/images/confluence-glance-icon.png";
        Name name = new Name(glanceTitle);
        Condition[] conditions = null;
        Icon icon = new Icon(iconUrl);
        String queryUrl = baseUrl + "/rest/hipchat/spacetoroom/latest/connect-api/glance-data";
        String target = ConfluenceConnectUtil.buildWebPanelKey(roomId);
        return new Glance(glanceKey, name, conditions, icon, queryUrl, target);
    }

    public static String buildGlanceKey(String roomId) {
        return "confluence-glance-" + roomId;
    }

    public static GlanceData buildGlanceData(String roomId, SettingsManager settingsManager, EntityToRoomMappingManager entityToRoomMappingManager, SpaceManager spaceManager, I18nResolver i18nResolver, ConfluenceGlanceUpdateMetadata metadata) {
        Settings settings = settingsManager.getGlobalSettings();
        String glanceTitle = ConfluenceConnectUtil.buildGlanceTitle(roomId, settingsManager, entityToRoomMappingManager, spaceManager);
        GlanceData.Label label = new GlanceData.Label(GlanceData.Label.Type.html, glanceTitle);
        String lozengeLabel = i18nResolver.getText("confluence.plugins.hipchat.glance.lozenge.text");
        GlanceData.Status.LozengeValue.Type lozengeType = GlanceData.Status.LozengeValue.Type.CURRENT;
        GlanceData.Status.LozengeValue lozengeValue = new GlanceData.Status.LozengeValue(lozengeLabel, lozengeType);
        GlanceData.Status status = new GlanceData.Status(GlanceData.Status.Type.lozenge, (GlanceData.Status.Value)lozengeValue);
        GlanceData glanceData = new GlanceData(label, (GlanceData.Status)(ConfluenceConnectUtil.isInGlanceBetaPeriod() ? status : null), (Object)metadata);
        return glanceData;
    }

    private static final String buildGlanceTitle(String roomId, SettingsManager settingsManager, EntityToRoomMappingManager entityToRoomMappingManager, SpaceManager spaceManager) {
        boolean multipleSpacesMapped = false;
        String mappedSpaceKey = null;
        Iterable<AOEntityToRoomMapping> mappings = entityToRoomMappingManager.getForRoom(roomId);
        for (AOEntityToRoomMapping mapping : mappings) {
            String spaceKey = mapping.getEntityKey();
            if (mappedSpaceKey == null) {
                mappedSpaceKey = spaceKey;
                continue;
            }
            if (spaceKey.equals(mappedSpaceKey)) continue;
            multipleSpacesMapped = true;
            break;
        }
        if (mappedSpaceKey == null || multipleSpacesMapped) {
            Settings settings = settingsManager.getGlobalSettings();
            return ConfluenceConnectUtil.getSiteTitle(settings);
        }
        Space space = spaceManager.getSpace(mappedSpaceKey);
        String spaceName = space.getName();
        return spaceName;
    }

    public static boolean isInGlanceBetaPeriod() {
        Calendar expiryDate = Calendar.getInstance();
        expiryDate.set(2016, 8, 30);
        return new Date().before(expiryDate.getTime());
    }

    public static WebPanel buildWebPanelDefinition(String roomId, SettingsManager settingsManager) {
        Settings settings = settingsManager.getGlobalSettings();
        String key = ConfluenceConnectUtil.buildWebPanelKey(roomId);
        Name name = new Name("confluence-webpanel");
        String baseUrl = settings.getBaseUrl();
        String url = baseUrl + "/plugins/servlet/hipchat/webpanel/confluence";
        String location = "hipchat.sidebar.right";
        return new WebPanel(key, name, url, location, "none");
    }

    public static String buildWebPanelKey(String roomId) {
        return "confluence-webpanel-" + roomId;
    }

    public static String getSiteTitle(Settings settings) {
        String siteTitle = settings.getSiteTitle();
        if (siteTitle == null) {
            siteTitle = DEFAULT_GLANCE_TITLE;
        } else if ((siteTitle = siteTitle.trim()).length() == 0) {
            siteTitle = DEFAULT_GLANCE_TITLE;
        }
        return siteTitle;
    }
}

