/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.soy;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.HipChatRoomDefinition;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.SpaceToRoomConfiguration;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications.SpaceToRoomNotificationProvider;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsHipChatRoomNotificationEnabledFunction
implements SoyServerFunction<Boolean>,
SoyClientFunction {
    private static final Logger LOG = LoggerFactory.getLogger(IsHipChatRoomNotificationEnabledFunction.class);
    private static final int DEFAULT_BY_ACTIVE_ARG_INDEX = 3;
    private static final Set<Integer> VALID_ARG_SIZES = ImmutableSet.of((Object)3, (Object)4);
    private final SpaceToRoomNotificationProvider spaceToRoomNotificationProvider;

    public IsHipChatRoomNotificationEnabledFunction(SpaceToRoomNotificationProvider spaceToRoomNotificationProvider) {
        this.spaceToRoomNotificationProvider = spaceToRoomNotificationProvider;
    }

    public String getName() {
        return "isHipChatRoomNotificationEnabled";
    }

    public Boolean apply(Object ... args) {
        SpaceToRoomConfiguration spaceToRoomConfiguration = (SpaceToRoomConfiguration)args[0];
        HipChatRoomDefinition room = (HipChatRoomDefinition)args[1];
        String notificationName = (String)args[2];
        Option<NotificationType> spaceToRoomNotificationOption = this.spaceToRoomNotificationProvider.getNotificationTypeForKey(notificationName);
        boolean enabled = spaceToRoomNotificationOption.isDefined() && spaceToRoomConfiguration.isRoomNotificationEnabled(room, (NotificationType)spaceToRoomNotificationOption.get());
        return enabled;
    }

    public JsExpression generate(JsExpression ... jsExpressions) {
        JsExpression isEnabled = new JsExpression("false");
        if (jsExpressions.length > 3) {
            isEnabled = jsExpressions[3];
        }
        return isEnabled;
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

