/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.service;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateFromTemplateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveCompletedEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.space.SpaceArchivedEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.event.events.space.SpacePermissionsUpdateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.event.events.space.SpaceUpdateEvent;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomMapping;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomMappingManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.BlogPostShareEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConfluenceGlanceUpdateMetadata;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.PageShareEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.SidebarCategory;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.ConnectEnablementManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatNotificationEnablementStateProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSidebarUpdater;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.util.ConfluenceConnectUtil;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.glances.GlanceData;
import com.atlassian.hipchat.api.glances.GlanceUpdateData;
import com.atlassian.hipchat.api.glances.RoomAddonUiUpdateData;
import com.atlassian.hipchat.api.rooms.RoomService;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.events.NotificationBlockedEvent;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.api.user.HipChatUserFinder;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Internal
public final class DefaultHipChatSidebarUpdater
implements HipChatSidebarUpdater,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHipChatSidebarUpdater.class);
    private static final ConfluenceGlanceUpdateMetadata userPermissionChangedMetadata = new ConfluenceGlanceUpdateMetadata("user-permission-changed");
    private static final ConfluenceGlanceUpdateMetadata contentChangedMetadata = new ConfluenceGlanceUpdateMetadata("content-changed");
    private static final ConfluenceGlanceUpdateMetadata contentViewedMetadata = new ConfluenceGlanceUpdateMetadata("content-viewed");
    private static final Map<SidebarCategory, ConfluenceGlanceUpdateMetadata> sidebarCategoriesToMetadata = new EnumMap<SidebarCategory, ConfluenceGlanceUpdateMetadata>(SidebarCategory.class);
    private static final ConfluenceGlanceUpdateMetadata sidebarDisabledMetadata;
    private static final ConfluenceGlanceUpdateMetadata spaceToRoomMappingUpdateMetadata;
    private static final ConfluenceGlanceUpdateMetadata shareFailureMetadata;
    private final HipChatLinkProvider hipChatLinkProvider;
    private final EntityToRoomMappingManager entityToRoomMappingManager;
    private final HipChatUserFinder hipChatUserFinder;
    private final SettingsManager settingsManager;
    private final SpaceManager spaceManager;
    private final HipChatNotificationEnablementStateProvider hipChatNotificationEnablementStateProvider;
    private final ConnectEnablementManager connectEnablementManager;
    private final I18nResolver i18nResolver;
    private final EventPublisher eventPublisher;

    public DefaultHipChatSidebarUpdater(HipChatLinkProvider hipChatLinkProvider, EntityToRoomMappingManager entityToRoomMappingManager, HipChatUserFinder hipChatUserFinder, SettingsManager settingsManager, SpaceManager spaceManager, HipChatNotificationEnablementStateProvider hipChatNotificationEnablementStateProvider, ConnectEnablementManager connectEnablementManager, I18nResolver i18nResolver, EventPublisher eventPublisher) {
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.entityToRoomMappingManager = entityToRoomMappingManager;
        this.hipChatUserFinder = hipChatUserFinder;
        this.settingsManager = settingsManager;
        this.spaceManager = spaceManager;
        this.hipChatNotificationEnablementStateProvider = hipChatNotificationEnablementStateProvider;
        this.connectEnablementManager = connectEnablementManager;
        this.i18nResolver = i18nResolver;
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.hipChatNotificationEnablementStateProvider.isNotificationsEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Register Hipchat sidebar updater event listener");
            }
            this.eventPublisher.register((Object)this);
        } else {
            logger.info("Detected notification processing is disabled.");
        }
    }

    public void destroy() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Un-register Hipchat sidebar updater event listener");
        }
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPageEvent(PageEvent pageEvent) {
        Option<HipChatLink> hipChatLinkOption;
        if (this.connectEnablementManager.isEnabled() && (hipChatLinkOption = this.getHipChatLink()).isDefined()) {
            HipChatLink hipChatLink = (HipChatLink)hipChatLinkOption.get();
            if (pageEvent instanceof PageCreateEvent || pageEvent instanceof PageCreateFromTemplateEvent || pageEvent instanceof PageUpdateEvent || pageEvent instanceof PageRemoveEvent || pageEvent instanceof PageRestoreEvent) {
                Page page = pageEvent.getPage();
                Space space = page.getSpace();
                this.processSpaceRelatedEvent(hipChatLink, SidebarCategory.CHANGED, space);
            }
        }
    }

    @EventListener
    public void onPageMoveCompletedEvent(PageMoveCompletedEvent pageMoveCompletedEvent) {
        Option<HipChatLink> hipChatLinkOption;
        if (this.connectEnablementManager.isEnabled() && (hipChatLinkOption = this.getHipChatLink()).isDefined()) {
            HipChatLink hipChatLink = (HipChatLink)hipChatLinkOption.get();
            Space oldSpace = pageMoveCompletedEvent.getOldSpace();
            EnumMap<SidebarCategory, Set<String>> sidebarCategoriesToAffectedRoomIds = new EnumMap<SidebarCategory, Set<String>>(SidebarCategory.class);
            this.addRelatedRoomId(SidebarCategory.CHANGED, oldSpace, sidebarCategoriesToAffectedRoomIds);
            List pages = pageMoveCompletedEvent.getMovedPageList();
            for (Page page : pages) {
                this.addRelatedRoomId(SidebarCategory.CHANGED, page, sidebarCategoriesToAffectedRoomIds);
            }
            this.processSpaceRelatedEvent(hipChatLink, sidebarCategoriesToAffectedRoomIds);
        }
    }

    @EventListener
    public void onBlogPostEvent(BlogPostEvent blogPostEvent) {
        Option<HipChatLink> hipChatLinkOption;
        if (this.connectEnablementManager.isEnabled() && (hipChatLinkOption = this.getHipChatLink()).isDefined()) {
            HipChatLink hipChatLink = (HipChatLink)hipChatLinkOption.get();
            if (blogPostEvent instanceof BlogPostCreateEvent || blogPostEvent instanceof BlogPostUpdateEvent || blogPostEvent instanceof BlogPostRemoveEvent || blogPostEvent instanceof BlogPostRestoreEvent) {
                BlogPost blogPost = blogPostEvent.getBlogPost();
                Space space = blogPost.getSpace();
                this.processSpaceRelatedEvent(hipChatLink, SidebarCategory.CHANGED, space);
            } else if (blogPostEvent instanceof BlogPostMovedEvent) {
                BlogPostMovedEvent blogPostMovedEvent = (BlogPostMovedEvent)blogPostEvent;
                EnumMap<SidebarCategory, Set<String>> sidebarCategoriesToAffectedRoomIds = new EnumMap<SidebarCategory, Set<String>>(SidebarCategory.class);
                Space originalSpace = blogPostMovedEvent.getOriginalSpace();
                this.addRelatedRoomId(SidebarCategory.CHANGED, originalSpace, sidebarCategoriesToAffectedRoomIds);
                Space currentSpace = blogPostMovedEvent.getCurrentSpace();
                this.addRelatedRoomId(SidebarCategory.CHANGED, currentSpace, sidebarCategoriesToAffectedRoomIds);
                this.processSpaceRelatedEvent(hipChatLink, sidebarCategoriesToAffectedRoomIds);
            }
        }
    }

    @EventListener
    public void onCommentEvent(CommentEvent commentEvent) {
        Option<HipChatLink> hipChatLinkOption;
        if (this.connectEnablementManager.isEnabled() && (hipChatLinkOption = this.getHipChatLink()).isDefined()) {
            HipChatLink hipChatLink = (HipChatLink)hipChatLinkOption.get();
            Comment comment = commentEvent.getComment();
            Space space = comment.getSpace();
            this.processSpaceRelatedEvent(hipChatLink, SidebarCategory.CHANGED, space);
        }
    }

    @EventListener
    public void onSpaceEvent(SpaceEvent spaceEvent) {
        Option<HipChatLink> hipChatLinkOption;
        if (this.connectEnablementManager.isEnabled() && (hipChatLinkOption = this.getHipChatLink()).isDefined()) {
            HipChatLink hipChatLink = (HipChatLink)hipChatLinkOption.get();
            if (spaceEvent instanceof SpaceArchivedEvent || spaceEvent instanceof SpaceRemoveEvent) {
                Space space = spaceEvent.getSpace();
                this.processSpaceRelatedEvent(hipChatLink, SidebarCategory.CHANGED, space);
            } else if (spaceEvent instanceof SpaceUpdateEvent) {
                SpaceUpdateEvent spaceUpdateEvent = (SpaceUpdateEvent)spaceEvent;
                EnumMap<SidebarCategory, Set<String>> sidebarCategoriesToAffectedRoomIds = new EnumMap<SidebarCategory, Set<String>>(SidebarCategory.class);
                Space originalSpace = spaceUpdateEvent.getSpace();
                Space currentSpace = spaceUpdateEvent.getSpace();
                this.addRelatedRoomId(SidebarCategory.CHANGED, originalSpace, sidebarCategoriesToAffectedRoomIds);
                this.addRelatedRoomId(SidebarCategory.CHANGED, currentSpace, sidebarCategoriesToAffectedRoomIds);
                this.processSpaceRelatedEvent(hipChatLink, sidebarCategoriesToAffectedRoomIds);
            } else if (spaceEvent instanceof SpacePermissionsUpdateEvent) {
                EnumMap<SidebarCategory, Set<String>> sidebarCategoriesToAffectedRoomIds = new EnumMap<SidebarCategory, Set<String>>(SidebarCategory.class);
                SpacePermissionsUpdateEvent spacePermissionsUpdateEvent = (SpacePermissionsUpdateEvent)spaceEvent;
                Space space = spacePermissionsUpdateEvent.getSpace();
                this.addRelatedRoomId(SidebarCategory.VIEWED, space, sidebarCategoriesToAffectedRoomIds);
                this.addRelatedRoomId(SidebarCategory.CHANGED, space, sidebarCategoriesToAffectedRoomIds);
                this.processSpaceRelatedEvent(hipChatLink, sidebarCategoriesToAffectedRoomIds);
            }
        }
    }

    @EventListener
    public void onNotificationBlockedEvent(NotificationBlockedEvent notificationBlockedEvent) {
        Option<HipChatLink> hipChatLinkOption;
        if (this.connectEnablementManager.isEnabled() && (hipChatLinkOption = this.getHipChatLink()).isDefined()) {
            HipChatLink hipChatLink = (HipChatLink)hipChatLinkOption.get();
            Object sourceEvent = notificationBlockedEvent.getSourceEvent();
            if (sourceEvent instanceof PageShareEvent) {
                PageShareEvent pageShareEvent = (PageShareEvent)sourceEvent;
                String roomId = pageShareEvent.getRoomId();
                this.pushShareFailureResponse(roomId, hipChatLink);
            } else if (sourceEvent instanceof BlogPostShareEvent) {
                BlogPostShareEvent blogPostShareEvent = (BlogPostShareEvent)sourceEvent;
                String roomId = blogPostShareEvent.getRoomId();
                this.pushShareFailureResponse(roomId, hipChatLink);
            }
        }
    }

    @Override
    public Promise<Result<Void>> pushSidebarDisabledEvent(String roomId, String glanceKey) {
        return this.pushEvent(roomId, glanceKey, sidebarDisabledMetadata);
    }

    @Override
    public Promise<Result<Void>> pushSpaceToRoomMappingUpdateEvent(String roomId, String glanceKey) {
        return this.pushEvent(roomId, glanceKey, spaceToRoomMappingUpdateMetadata);
    }

    private Promise<Result<Void>> pushEvent(String roomId, String glanceKey, ConfluenceGlanceUpdateMetadata metadata) {
        Option<HipChatLink> hipChatLinkOption = this.getHipChatLink();
        if (hipChatLinkOption.isDefined()) {
            HipChatLink hipChatLink = (HipChatLink)hipChatLinkOption.get();
            HipChatAPI addonApi = hipChatLink.getAddonApi();
            RoomService roomService = addonApi.rooms();
            GlanceData glanceData = ConfluenceConnectUtil.buildGlanceData(roomId, this.settingsManager, this.entityToRoomMappingManager, this.spaceManager, this.i18nResolver, metadata);
            GlanceUpdateData glanceUpdateData = new GlanceUpdateData(glanceKey, glanceData);
            RoomAddonUiUpdateData roomAddonUiUpdateData = new RoomAddonUiUpdateData.Builder().addGlance(glanceUpdateData).build();
            return roomService.updateRoomAddonUi(roomId, roomAddonUiUpdateData);
        }
        Result noLinkResult = Result.error((String)"Hipchat link not defined");
        return Promises.promise(noLinkResult);
    }

    private Option<HipChatLink> getHipChatLink() {
        try {
            return this.hipChatLinkProvider.getDefaultLink();
        }
        catch (IllegalStateException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring inability to get Hipchat link - this occurs during startup when AO is not yet ready.");
            }
            return Option.none();
        }
    }

    private void processSpaceRelatedEvent(HipChatLink hipChatLink, SidebarCategory sidebarCategory, Space space) {
        TreeSet<String> relatedRoomIds = new TreeSet<String>();
        String spaceKey = space.getKey();
        Iterable<AOEntityToRoomMapping> mappings = this.entityToRoomMappingManager.getForEntity(spaceKey);
        for (AOEntityToRoomMapping mapping : mappings) {
            String roomId = mapping.getRoomId();
            relatedRoomIds.add(roomId);
        }
        ImmutableMap sidebarCategoriesToAffectedRoomIds = new ImmutableMap.Builder().put((Object)sidebarCategory, relatedRoomIds).build();
        this.processSpaceRelatedEvent(hipChatLink, (Map<SidebarCategory, Set<String>>)sidebarCategoriesToAffectedRoomIds);
    }

    private void processSpaceRelatedEvent(HipChatLink hipChatLink, Map<SidebarCategory, Set<String>> sidebarCategoriesToAffectedRoomIds) {
        HipChatAPI addonApi = hipChatLink.getAddonApi();
        RoomService roomService = addonApi.rooms();
        for (Map.Entry<SidebarCategory, Set<String>> entry : sidebarCategoriesToAffectedRoomIds.entrySet()) {
            SidebarCategory sidebarCategory = entry.getKey();
            ConfluenceGlanceUpdateMetadata metadata = sidebarCategoriesToMetadata.get((Object)sidebarCategory);
            if (metadata == null) continue;
            Set<String> affectedRoomIds = entry.getValue();
            for (String roomId : affectedRoomIds) {
                GlanceData glanceData = ConfluenceConnectUtil.buildGlanceData(roomId, this.settingsManager, this.entityToRoomMappingManager, this.spaceManager, this.i18nResolver, metadata);
                String glanceKey = ConfluenceConnectUtil.buildGlanceKey(roomId);
                GlanceUpdateData glanceUpdateData = new GlanceUpdateData(glanceKey, glanceData);
                RoomAddonUiUpdateData roomAddonUiUpdateData = new RoomAddonUiUpdateData.Builder().addGlance(glanceUpdateData).build();
                roomService.updateRoomAddonUi(roomId, roomAddonUiUpdateData);
            }
        }
    }

    private void addRelatedRoomId(SidebarCategory sidebarCategory, Page page, Map<SidebarCategory, Set<String>> sidebarCategoriesToAffectedRoomIds) {
        Space space = page.getSpace();
        this.addRelatedRoomId(sidebarCategory, space, sidebarCategoriesToAffectedRoomIds);
    }

    private void addRelatedRoomId(SidebarCategory sidebarCategory, Space space, Map<SidebarCategory, Set<String>> sidebarCategoriesToAffectedRoomIds) {
        Set<String> relatedRoomIds = sidebarCategoriesToAffectedRoomIds.get((Object)sidebarCategory);
        if (relatedRoomIds == null) {
            relatedRoomIds = new TreeSet<String>();
            sidebarCategoriesToAffectedRoomIds.put(sidebarCategory, relatedRoomIds);
        }
        String spaceKey = space.getKey();
        Iterable<AOEntityToRoomMapping> mappings = this.entityToRoomMappingManager.getForEntity(spaceKey);
        for (AOEntityToRoomMapping mapping : mappings) {
            String roomId = mapping.getRoomId();
            relatedRoomIds.add(roomId);
        }
    }

    private void pushShareFailureResponse(String roomId, HipChatLink hipChatLink) {
        GlanceData glanceData = ConfluenceConnectUtil.buildGlanceData(roomId, this.settingsManager, this.entityToRoomMappingManager, this.spaceManager, this.i18nResolver, shareFailureMetadata);
        String glanceKey = ConfluenceConnectUtil.buildGlanceKey(roomId);
        GlanceUpdateData glanceUpdateData = new GlanceUpdateData(glanceKey, glanceData);
        RoomAddonUiUpdateData roomAddonUiUpdateData = new RoomAddonUiUpdateData.Builder().addGlance(glanceUpdateData).build();
        HipChatAPI addonApi = hipChatLink.getAddonApi();
        RoomService roomService = addonApi.rooms();
        roomService.updateRoomAddonUi(roomId, roomAddonUiUpdateData);
    }

    static {
        sidebarCategoriesToMetadata.put(SidebarCategory.CHANGED, contentChangedMetadata);
        sidebarCategoriesToMetadata.put(SidebarCategory.VIEWED, contentViewedMetadata);
        sidebarDisabledMetadata = new ConfluenceGlanceUpdateMetadata("sidebar-disabled-event");
        spaceToRoomMappingUpdateMetadata = new ConfluenceGlanceUpdateMetadata("space-to-room-mapping-update");
        shareFailureMetadata = new ConfluenceGlanceUpdateMetadata("share-failure");
    }
}

