/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.restcompatibility;

import com.atlassian.confluence.plugins.hipchat.user.ConfluenceInviteUserReferenceSetBuilder;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.hipchat.api.Result;
import com.atlassian.plugins.hipchat.user.InvitationTracker;
import com.atlassian.plugins.hipchat.user.UserReferenceSet;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/user")
public class SpaceToRoomUserResource {
    public static final int MAX_RESULTS_ALLOWED = 1000;
    private final InvitationTracker invitationTracker;
    private final ConfluenceInviteUserReferenceSetBuilder confluenceInviteUserNameSetBuilder;
    private final PermissionManager permissionManager;

    public SpaceToRoomUserResource(InvitationTracker invitationTracker, ConfluenceInviteUserReferenceSetBuilder confluenceInviteUserNameSetBuilder, PermissionManager permissionManager) {
        this.invitationTracker = (InvitationTracker)Preconditions.checkNotNull((Object)invitationTracker);
        this.confluenceInviteUserNameSetBuilder = (ConfluenceInviteUserReferenceSetBuilder)Preconditions.checkNotNull((Object)confluenceInviteUserNameSetBuilder);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
    }

    @Path(value="/find-invite-users")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response findInviteUserNames(@QueryParam(value="space-keys-csv") @DefaultValue(value="") String spaceKeysCsv, @QueryParam(value="max-results") @DefaultValue(value="10") int maxResults) {
        if (maxResults > 1000) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Bad request - max-results (" + maxResults + ") larger than " + 1000)).build();
        }
        if (this.invitationTracker.hasPreviouslySuggestedInvitees()) {
            UserReferenceSet userReferenceSet = new UserReferenceSet(Collections.EMPTY_SET);
            Result userNameSetResult = Result.success((Object)userReferenceSet);
            return Response.ok((Object)userNameSetResult.success()).build();
        }
        try {
            Object[] spaceKeys;
            Set spaceKeysSet = spaceKeysCsv == null || spaceKeysCsv.trim().length() == 0 ? Collections.EMPTY_SET : ((spaceKeys = spaceKeysCsv.split(",")) == null || spaceKeys.length == 0 ? Collections.EMPTY_SET : Sets.newHashSet((Object[])spaceKeys));
            UserReferenceSet userReferenceSet = this.confluenceInviteUserNameSetBuilder.build(maxResults, spaceKeysSet);
            if (!this.isAdmin(spaceKeysSet)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            Result userNameSetResult = Result.success((Object)userReferenceSet);
            return Response.ok((Object)userNameSetResult.success()).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    private boolean isAdmin(Set<String> spaceKeys) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            return true;
        }
        if (spaceKeys.size() == 0) {
            return false;
        }
        for (String spaceKey : spaceKeys) {
            if (this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)spaceKey)) continue;
            return false;
        }
        return true;
    }
}

