/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications.SpaceToRoomNotificationProvider;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.hipchat.api.cards.Card;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.hipchat.api.notification.HipChatCardNotification;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotification;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationContext;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationContext2;
import com.atlassian.plugins.hipchat.api.notification.HipChatUserActionNotification;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.atlassian.plugins.hipchat.api.notification.RoomToNotify;
import com.atlassian.plugins.hipchat.descriptor.HipChatNotificationContextDescriptor;
import com.atlassian.plugins.hipchat.descriptor.HipChatNotificationDescriptor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.List;

public class DefaultSpaceToRoomNotificationProvider
implements SpaceToRoomNotificationProvider {
    private final SafeAccessViaPluginAccessor safePluginAccessor;
    private final I18nResolver i18nResolver;
    private final TransactionTemplate transactionTemplate;
    private final EventPublisher eventPublisher;

    public DefaultSpaceToRoomNotificationProvider(PluginAccessor pluginAccessor, I18nResolver i18nResolver, TransactionTemplate transactionTemplate, EventPublisher eventPublisher) {
        this.i18nResolver = i18nResolver;
        this.safePluginAccessor = SafePluginPointAccess.to(pluginAccessor);
        this.transactionTemplate = transactionTemplate;
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
    }

    @Override
    public Iterable<NotificationType> getNotificationTypes() {
        return this.safePluginAccessor.forType(HipChatNotificationDescriptor.class, (moduleDescriptor, module) -> NotificationType.fromModuleDescriptor((HipChatNotificationDescriptor)moduleDescriptor, (I18nResolver)this.i18nResolver, (HipChatNotification)module));
    }

    @Override
    public Iterable<NotificationType> getNotificationTypes(String context) {
        Iterable<NotificationType> notificationTypes = this.getNotificationTypes();
        return Iterables.filter(notificationTypes, notificationType -> notificationType.getContext().equals(context));
    }

    @Override
    public Iterable<SpaceToRoomNotificationProvider.RoomNotification> getNotificationsForEvent(Object event) {
        ImmutableList.Builder messages = ImmutableList.builder();
        this.safePluginAccessor.forType(HipChatNotificationDescriptor.class, (moduleDescriptor, module) -> {
            if (module.getEventClass().isAssignableFrom(event.getClass())) {
                if (!module.shouldSend(event)) {
                    HipChatUserActionNotification userActionNotification;
                    Option notificationBlockedEventOption;
                    if (module instanceof HipChatUserActionNotification && (notificationBlockedEventOption = (userActionNotification = (HipChatUserActionNotification)module).buildNotificationBlockedEvent(event)).isDefined()) {
                        Object notificationBlockedEvent = notificationBlockedEventOption.get();
                        this.eventPublisher.publish(notificationBlockedEvent);
                    }
                    return;
                }
                NotificationType notificationType = NotificationType.fromModuleDescriptor((HipChatNotificationDescriptor)moduleDescriptor, (I18nResolver)this.i18nResolver, (HipChatNotification)module);
                Option<HipChatNotificationContext2> context = this.getContext(notificationType);
                if (context.isEmpty()) {
                    return;
                }
                this.transactionTemplate.execute(() -> {
                    Iterable rooms = ((HipChatNotificationContext2)context.get()).getRoomToNotify(event, notificationType);
                    if (rooms.iterator().hasNext()) {
                        String message = module.getMessage(event);
                        Option card = Option.none();
                        Option attachTo = Option.none();
                        if (module instanceof HipChatCardNotification) {
                            HipChatCardNotification cardModule = (HipChatCardNotification)module;
                            card = cardModule.getCard(event);
                            attachTo = cardModule.getAttachTo();
                        }
                        for (RoomToNotify room : rooms) {
                            messages.add((Object)new SpaceToRoomNotificationProvider.RoomNotification(room.getRoomId(), message, room.isNotify(), (Option<Card>)card, (Option<String>)attachTo));
                        }
                    }
                    return null;
                });
            }
        });
        return messages.build();
    }

    @Override
    public Option<NotificationType> getNotificationTypeForKey(String key) {
        List<NotificationType> notifications = this.safePluginAccessor.forType(HipChatNotificationDescriptor.class, (moduleDescriptor, module) -> {
            if (key.equals(moduleDescriptor.getValue())) {
                return NotificationType.fromModuleDescriptor((HipChatNotificationDescriptor)moduleDescriptor, (I18nResolver)this.i18nResolver, (HipChatNotification)module);
            }
            return null;
        });
        Optional notificationType = Optional.fromNullable((Object)Iterables.find(notifications, input -> input != null, null));
        if (notificationType.isPresent()) {
            return Option.some((Object)notificationType.get());
        }
        return Option.none();
    }

    private Option<HipChatNotificationContext2> getContext(NotificationType notificationType) {
        List<HipChatNotificationContext> notifications = this.safePluginAccessor.forType(HipChatNotificationContextDescriptor.class, (moduleDescriptor, module) -> {
            if (notificationType.getContext().equals(moduleDescriptor.getValue())) {
                return module;
            }
            return null;
        });
        Optional context = Optional.fromNullable((Object)Iterables.find(notifications, input -> input != null, null));
        if (context.isPresent()) {
            return Option.some((Object)((HipChatNotificationContext2)context.get()));
        }
        return Option.none();
    }
}

