/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.listener;

import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSpaceToRoomService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SpaceEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SpaceEventListener.class);
    private final EventPublisher eventPublisher;
    private final HipChatSpaceToRoomService spaceToRoomService;

    public SpaceEventListener(EventPublisher eventPublisher, HipChatSpaceToRoomService spaceToRoomService) {
        this.eventPublisher = eventPublisher;
        this.spaceToRoomService = spaceToRoomService;
    }

    @EventListener
    public void spaceRemovedEvent(SpaceRemoveEvent spaceRemoveEvent) {
        String spaceKey = spaceRemoveEvent.getSpace().getKey();
        log.debug("Removing room notifications for deleted space {}", (Object)spaceKey);
        int notificationsRemoved = this.spaceToRoomService.removeNotificationsForSpace(spaceKey);
        log.debug("{} room notifications removed for deleted space {}", (Object)notificationsRemoved, (Object)spaceKey);
    }

    public void afterPropertiesSet() throws Exception {
        log.debug("Register Confluence space event listener");
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        log.debug("Unregister Confluence space event listener");
        this.eventPublisher.unregister((Object)this);
    }
}

