/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomMapping;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomMappingManager;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.google.common.collect.ImmutableList;
import net.java.ao.DBParam;

@Internal
public class DefaultEntityToRoomMappingManager
implements EntityToRoomMappingManager {
    private final ActiveObjects ao;

    public DefaultEntityToRoomMappingManager(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Iterable<AOEntityToRoomMapping> getAll() {
        return ImmutableList.copyOf((Object[])this.ao.find(AOEntityToRoomMapping.class));
    }

    @Override
    public Iterable<AOEntityToRoomMapping> getForRoom(String roomId) {
        return ImmutableList.copyOf((Object[])this.ao.find(AOEntityToRoomMapping.class, "ROOM_ID = ?", new Object[]{roomId}));
    }

    @Override
    public int countForRoom(String roomId) {
        return this.ao.count(AOEntityToRoomMapping.class, "ROOM_ID = ?", new Object[]{roomId});
    }

    @Override
    public Iterable<AOEntityToRoomMapping> getForEntity(String entityKey) {
        return ImmutableList.copyOf((Object[])this.ao.find(AOEntityToRoomMapping.class, "ENTITY_KEY = ?", new Object[]{entityKey}));
    }

    @Override
    public boolean hasConfigurationForRoom(String roomId) {
        return this.ao.count(AOEntityToRoomMapping.class, "ROOM_ID = ?", new Object[]{roomId}) > 0;
    }

    @Override
    public boolean hasConfigurationForEntity(String entityKey) {
        return this.ao.count(AOEntityToRoomMapping.class, "ENTITY_KEY = ?", new Object[]{entityKey}) > 0;
    }

    @Override
    public boolean hasConfigurationForEntityRoomAndType(String entity, String roomId, NotificationType type) {
        return this.ao.count(AOEntityToRoomMapping.class, "ENTITY_KEY = ? AND ROOM_ID = ? AND MESSAGE_TYPE_KEY = ?", new Object[]{entity, roomId, type.getKey()}) > 0;
    }

    @Override
    public Iterable<AOEntityToRoomMapping> getForEntityAndRoom(String entityKey, String roomId) {
        return ImmutableList.copyOf((Object[])this.ao.find(AOEntityToRoomMapping.class, "ENTITY_KEY = ? AND ROOM_ID = ?", new Object[]{entityKey, roomId}));
    }

    @Override
    public Iterable<AOEntityToRoomMapping> getForEntityAndType(String entityKey, NotificationType notificationType) {
        return ImmutableList.copyOf((Object[])this.ao.find(AOEntityToRoomMapping.class, "ENTITY_KEY = ? AND MESSAGE_TYPE_KEY = ?", new Object[]{entityKey, notificationType.getKey()}));
    }

    @Override
    public void addNotificationForEntityAndRoom(String entityKey, String roomId, NotificationType notificationType) {
        String notificationTypeKey = notificationType.getKey();
        AOEntityToRoomMapping entityToRoomMapping = (AOEntityToRoomMapping)this.ao.create(AOEntityToRoomMapping.class, new DBParam[0]);
        entityToRoomMapping.setEntityKey(entityKey);
        entityToRoomMapping.setRoomId(roomId);
        entityToRoomMapping.setMessageTypeKey(notificationTypeKey);
        entityToRoomMapping.save();
    }

    @Override
    public int removeNotificationsForEntity(String entityKey) {
        return this.ao.deleteWithSQL(AOEntityToRoomMapping.class, "ENTITY_KEY = ?", new Object[]{entityKey});
    }

    @Override
    public void removeNotificationsForEntityAndRoom(String entityKey, String roomId) {
        this.ao.deleteWithSQL(AOEntityToRoomMapping.class, "ENTITY_KEY = ? AND ROOM_ID = ?", new Object[]{entityKey, roomId});
    }

    @Override
    public void removeNotificationForEntityAndRoom(String entityKey, String roomId, NotificationType notificationType) {
        this.ao.deleteWithSQL(AOEntityToRoomMapping.class, "ENTITY_KEY = ? AND ROOM_ID = ? AND MESSAGE_TYPE_KEY = ?", new Object[]{entityKey, roomId, notificationType.getKey()});
    }
}

