/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.actions;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.actions.InviteUserWizardService;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.SpaceToRoomConfiguration;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications.SpaceToRoomNotificationProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSpaceToRoomService;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.view.ViewHelper;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.hipchat.api.HipChatDarkFeatureService;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPI;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPIService;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.atlassian.plugins.hipchat.api.routes.HipChatLinkRoutesProvider;
import com.atlassian.plugins.hipchat.api.routes.HipChatRoutesProvider;
import com.atlassian.plugins.hipchat.api.user.HipChatUserFinder;
import com.atlassian.plugins.hipchat.spi.HipChatRoutesProviderFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.List;
import java.util.Map;

@Internal
public class ViewSpaceConfigurationAction
extends AbstractSpaceAdminAction {
    @VisibleForTesting
    static final String ERROR_PERSONAL_SPACE = "error.personal.space";
    private final HipChatSpaceToRoomService hipChatSpaceToRoomService;
    private final HipChatLinkProvider hipChatLinkProvider;
    private final HipChatCompatAPI hipChatCompatApi;
    private final HipChatLinkRoutesProvider hipChatLinkRoutesProvider;
    private final HipChatUserFinder hipChatUserFinder;
    private final SpaceToRoomNotificationProvider spaceToRoomNotificationProvider;
    private final HipChatRoutesProviderFactory hipChatRoutesProviderFactory;
    private final HipChatDarkFeatureService hipChatDarkFeatureService;
    private final HipChatCompatAPIService hipChatCompatAPIService;
    private final InviteUserWizardService inviteUserWizardService;
    private List<SpaceToRoomConfiguration> configs;
    private Option<HipChatLink> defaultLink;
    private HipChatRoutesProvider routesProvider;

    public ViewSpaceConfigurationAction(HipChatSpaceToRoomService hipChatSpaceToRoomService, HipChatLinkProvider hipChatLinkProvider, HipChatLinkRoutesProvider hipChatLinkRoutesProvider, HipChatCompatAPI hipChatCompatApi, HipChatUserFinder hipChatUserFinder, SpaceToRoomNotificationProvider spaceToRoomNotificationProvider, HipChatRoutesProviderFactory hipChatRoutesProviderFactory, HipChatDarkFeatureService hipChatDarkFeatureService, HipChatCompatAPIService hipChatCompatAPIService, InviteUserWizardService inviteUserWizardService) {
        Preconditions.checkNotNull((Object)hipChatSpaceToRoomService);
        Preconditions.checkNotNull((Object)hipChatLinkProvider);
        Preconditions.checkNotNull((Object)hipChatLinkRoutesProvider);
        Preconditions.checkNotNull((Object)hipChatCompatApi);
        Preconditions.checkNotNull((Object)hipChatUserFinder);
        Preconditions.checkNotNull((Object)spaceToRoomNotificationProvider);
        Preconditions.checkNotNull((Object)hipChatRoutesProviderFactory);
        Preconditions.checkNotNull((Object)hipChatDarkFeatureService);
        Preconditions.checkNotNull((Object)hipChatCompatAPIService);
        Preconditions.checkNotNull((Object)inviteUserWizardService);
        this.hipChatSpaceToRoomService = hipChatSpaceToRoomService;
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.hipChatCompatApi = hipChatCompatApi;
        this.hipChatLinkRoutesProvider = hipChatLinkRoutesProvider;
        this.hipChatUserFinder = hipChatUserFinder;
        this.spaceToRoomNotificationProvider = spaceToRoomNotificationProvider;
        this.hipChatRoutesProviderFactory = hipChatRoutesProviderFactory;
        this.hipChatDarkFeatureService = hipChatDarkFeatureService;
        this.hipChatCompatAPIService = hipChatCompatAPIService;
        this.inviteUserWizardService = inviteUserWizardService;
    }

    public String execute() {
        Option link = this.hipChatLinkProvider.getDefaultLink();
        if (link.isEmpty()) {
            return "install";
        }
        HipChatRoutesProvider hipChatRoutesProvider = this.hipChatRoutesProviderFactory.getProvider((Map)ImmutableMap.of((Object)"space", (Object)this.getSpace()));
        this.setRoutesProvider(hipChatRoutesProvider);
        this.setConfig(Lists.newArrayList((Object[])new SpaceToRoomConfiguration[]{this.hipChatSpaceToRoomService.getSpaceToRoomConfiguration(this.getSpaceKey())}));
        this.setDefaultLink((Option<HipChatLink>)link);
        return "success";
    }

    public void setDefaultLink(Option<HipChatLink> link) {
        this.defaultLink = link;
    }

    public void setConfig(List<SpaceToRoomConfiguration> configs) {
        this.configs = configs;
    }

    public void setRoutesProvider(HipChatRoutesProvider routesProvider) {
        this.routesProvider = routesProvider;
    }

    public boolean isHipChatConnected() {
        return this.hipChatCompatApi.isEnabled();
    }

    public String getGroupName() {
        if (this.defaultLink.isDefined()) {
            return ((HipChatLink)this.defaultLink.get()).getGroupName();
        }
        return null;
    }

    public String getApiUrl() {
        if (this.defaultLink.isDefined()) {
            return ((HipChatLink)this.defaultLink.get()).getApiUrl();
        }
        return null;
    }

    public boolean isInitialInstall() {
        return this.inviteUserWizardService.isInitialInstall();
    }

    public String getHipChatUserName() {
        ConfluenceUser user = this.getAuthenticatedUser();
        Option hipChatUser = this.hipChatUserFinder.findHipChatUserIdAndName(user.getKey());
        if (hipChatUser.isEmpty()) {
            return null;
        }
        return (String)((Pair)hipChatUser.get()).right();
    }

    public String getAdminInviteUrl() {
        return this.routesProvider.getAdminInvitePage().toString();
    }

    public boolean isInviteEnabled() {
        return this.hipChatDarkFeatureService.isInviteToHipChatEnabled();
    }

    public HipChatLinkRoutesProvider getRoutes() {
        return this.hipChatLinkRoutesProvider;
    }

    public List<SpaceToRoomConfiguration> getConfigs() {
        return this.configs;
    }

    public Iterable<NotificationType> getNotificationTypes() {
        return this.spaceToRoomNotificationProvider.getNotificationTypes("space");
    }

    public ViewHelper getViewHelper() {
        return new ViewHelper();
    }

    public HipChatCompatAPIService.Version getApiVersion() {
        return this.hipChatCompatAPIService.getCurrentVersion();
    }
}

