/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.service;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.GlanceFeatureEnablementTransitionEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.ConnectEnablementManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatNotificationEnablementStateProvider;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.hipchat.tasks.HipChatTasksExecutor;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DefaultConnectEnablementManager
implements InitializingBean,
DisposableBean,
ConnectEnablementManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConnectEnablementManager.class);
    private static final long INITIAL_GLANCE_ENABLEMENT_DELAY_MILLISECONDS = 1L;
    private final HipChatNotificationEnablementStateProvider notificationEnablementStateProvider;
    private final EventPublisher eventPublisher;
    private final HipChatTasksExecutor hipChatTasksExecutor;
    private final DarkFeatureManager darkFeatureManager;
    private final AtomicBoolean inStartedState = new AtomicBoolean();
    private final AtomicBoolean glanceSynchronisationEnabled = new AtomicBoolean(false);

    public DefaultConnectEnablementManager(HipChatNotificationEnablementStateProvider notificationEnablementStateProvider, EventPublisher eventPublisher, HipChatTasksExecutor hipChatTasksExecutor, DarkFeatureManager darkFeatureManager) {
        this.notificationEnablementStateProvider = notificationEnablementStateProvider;
        this.eventPublisher = eventPublisher;
        this.hipChatTasksExecutor = hipChatTasksExecutor;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public boolean isEnabled() {
        return this.glanceSynchronisationEnabled.get();
    }

    public void afterPropertiesSet() throws Exception {
        this.inStartedState.set(true);
        if (this.notificationEnablementStateProvider.isNotificationsEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Register Hipchat connect enablement manager event listener");
            }
            this.hipChatTasksExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    if (DefaultConnectEnablementManager.this.inStartedState.get()) {
                        DefaultConnectEnablementManager.this.glanceSynchronisationEnabled.set(true);
                        boolean enabled = true;
                        GlanceFeatureEnablementTransitionEvent enablementTransitionEvent = new GlanceFeatureEnablementTransitionEvent(enabled);
                        DefaultConnectEnablementManager.this.eventPublisher.publish((Object)enablementTransitionEvent);
                    }
                }
            }, 1L, TimeUnit.MILLISECONDS);
        }
    }

    public void destroy() throws Exception {
        this.inStartedState.set(false);
        this.glanceSynchronisationEnabled.set(false);
        if (logger.isDebugEnabled()) {
            logger.debug("Un-register Hipchat connect enablement manager event listener");
        }
    }
}

